/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class SpringKafkaCloudEventEmitter
implements EventEmitter {
    @Autowired
    KafkaTemplate<String, String> emitter;
    @Value(value="${kogito.addon.cloudevents.kafka.kogito_outgoing_stream:kogito_outgoing_stream}")
    String defaultTopicName;
    @Autowired
    Environment env;
    @Autowired
    ObjectProvider<EventMarshaller> marshallerInstance;
    private EventMarshaller marshaller;
    @Autowired
    ConfigBean configBean;
    @Autowired
    ObjectMapper mapper;

    @PostConstruct
    void init() {
        this.marshaller = (EventMarshaller)this.marshallerInstance.getIfAvailable(() -> new DefaultEventMarshaller(this.mapper));
    }

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        return this.emitter.send(this.env.getProperty("kogito.addon.cloudevents.kafka.kogito_outgoing_stream." + type, this.defaultTopicName), (Object)this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e)).completable().thenApply(r -> null);
    }
}

