/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class SpringKafkaCloudEventEmitter<M>
implements EventEmitter {
    @Autowired
    KafkaTemplate<String, M> emitter;
    @Value(value="${kogito.addon.cloudevents.kafka.kogito_outgoing_stream:kogito_outgoing_stream}")
    String defaultTopicName;
    @Autowired
    Environment env;
    @Autowired
    EventMarshaller<M> marshaller;
    @Autowired
    ConfigBean configBean;
    @Autowired
    ObjectMapper mapper;

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        return this.emitter.send(this.env.getProperty("kogito.addon.cloudevents.kafka.kogito_outgoing_stream." + type, this.defaultTopicName), this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e)).completable().thenApply(r -> null);
    }
}

