/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.spring;

import java.util.HashMap;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;

@EnableKafka
@Configuration
public class SpringKafkaConsumerConfig {
    @Value(value="${spring.kafka.bootstrap-servers}")
    String kafkaBootstrapAddress;
    @Value(value="${spring.kafka.consumer.group-id}")
    String groupId;
    @Value(value="${spring.kafka.consumer.auto-offset-reset}")
    String offset;
    private static final Logger logger = LoggerFactory.getLogger(SpringKafkaConsumerConfig.class);

    @Bean
    public ConsumerFactory<String, String> consumerFactory() {
        logger.info("Creating consumer factory with bootstrap {} and groupid {}", (Object)this.kafkaBootstrapAddress, (Object)this.groupId);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.kafkaBootstrapAddress);
        props.put("group.id", this.groupId);
        props.put("auto.offset.reset", this.offset);
        props.put("key.deserializer", StringDeserializer.class);
        props.put("value.deserializer", StringDeserializer.class);
        return new DefaultKafkaConsumerFactory(props);
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<String, String> kafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.consumerFactory());
        factory.setBatchListener(Boolean.valueOf(true));
        return factory;
    }
}

