/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.dataindex;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.keycloak.KeycloakPrincipal;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.dataindex.DataIndexClient;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringBootDataIndexClient
implements DataIndexClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringBootDataIndexClient.class);
    private String dataIndexHttpURL;
    private RestTemplate restTemplate;
    private ObjectMapper objectMapper;
    private boolean isKeycloakAdapterAvailable = false;

    @Autowired
    public SpringBootDataIndexClient(@Value(value="${kogito.dataindex.http.url:http://localhost:8180}") String dataIndexHttpURL, @Autowired(required=false) RestTemplate restTemplate, @Autowired ObjectMapper objectMapper) {
        this.dataIndexHttpURL = dataIndexHttpURL;
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    @PostConstruct
    public void initialize() {
        if (this.restTemplate == null) {
            this.restTemplate = new RestTemplate();
            LOGGER.debug("No RestTemplate found, creating a default one");
        }
        try {
            Class.forName("org.springframework.security.core.context.SecurityContextHolder");
            Class.forName("org.keycloak.KeycloakPrincipal");
            this.setKeycloakAdapterAvailable(true);
        }
        catch (ClassNotFoundException exception) {
            LOGGER.debug("No Keycloak Adapter available, continue just propagating received authorization header");
        }
    }

    public boolean isKeycloakAdapterAvailable() {
        return this.isKeycloakAdapterAvailable;
    }

    public void setKeycloakAdapterAvailable(boolean keycloakAdapterAvailable) {
        this.isKeycloakAdapterAvailable = keycloakAdapterAvailable;
    }

    public List<NodeInstance> getNodeInstancesFromProcessInstance(String processInstanceId, String authHeader) {
        String query = this.getNodeInstancesQuery(processInstanceId);
        try {
            String requestJson = this.objectMapper.writeValueAsString(Collections.singletonMap("query", query));
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("Authorization", this.getAuthHeader(authHeader));
            HttpEntity request = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
            ResponseEntity result = this.restTemplate.postForEntity(this.dataIndexHttpURL + "/graphql", (Object)request, String.class, new Object[0]);
            if (result.getStatusCode().value() == 200) {
                return this.getNodeInstancesFromResponse(this.objectMapper.readTree((String)result.getBody()));
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new ProcessSVGException("Exception while trying to get data from Data Index service", (Throwable)e);
        }
    }

    protected List<NodeInstance> getNodeInstancesFromResponse(JsonNode response) {
        JsonNode pInstancesArray = response.path("data").path("ProcessInstances");
        if (pInstancesArray != null && !pInstancesArray.isEmpty()) {
            ArrayList<NodeInstance> nodes = new ArrayList<NodeInstance>();
            pInstancesArray.get(0).path("nodes").forEach(node -> nodes.add(new NodeInstance(Boolean.valueOf(!node.path("exit").isNull()), node.path("definitionId").asText())));
            return nodes;
        }
        return Collections.emptyList();
    }

    protected String getAuthHeader(String authHeader) {
        SecurityContext securityContext;
        if (this.isKeycloakAdapterAvailable() && (securityContext = SecurityContextHolder.getContext()) != null && securityContext.getAuthentication() != null && securityContext.getAuthentication().getPrincipal() instanceof KeycloakPrincipal) {
            return "Bearer " + ((KeycloakPrincipal)securityContext.getAuthentication().getPrincipal()).getKeycloakSecurityContext().getTokenString();
        }
        return authHeader;
    }
}

