/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg.dataindex;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.KeycloakSecurityContext;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.kie.kogito.svg.dataindex.SpringBootDataIndexClient;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@ExtendWith(value={MockitoExtension.class})
public class SpringBootDataIndexClientTest {
    private String PROCESS_INSTANCE_ID = "pId";
    private static final String jsonString = "{\n  \"data\": {\n    \"ProcessInstances\": [\n      {\n        \"id\": \"piId\",\n        \"processId\": \"processId\",\n        \"nodes\": [\n          {\n            \"definitionId\": \"_9861B686-DF6B-4B1C-B370-F9898EEB47FD\",\n            \"exit\": \"2020-10-11T06:49:47.26Z\"\n          },\n          {\n            \"definitionId\": \"_8B62D3CA-5D03-4B2B-832B-126469288BB4\",\n            \"exit\": null\n          }\n        ]\n      }     ]\n  }\n}";
    private SpringBootDataIndexClient client;
    final ObjectMapper objectMapper = new ObjectMapper();
    @Mock
    RestTemplate restTemplate;

    @BeforeEach
    void setUp() {
        this.client = new SpringBootDataIndexClient("data-indexURL", this.restTemplate, this.objectMapper);
    }

    @Test
    public void testGetNodeInstancesFromResponse() throws JsonProcessingException {
        JsonNode response = this.objectMapper.readTree(jsonString);
        List nodes = this.client.getNodeInstancesFromResponse(response);
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(2)).containsExactly((Object[])new NodeInstance[]{new NodeInstance(Boolean.valueOf(true), "_9861B686-DF6B-4B1C-B370-F9898EEB47FD"), new NodeInstance(Boolean.valueOf(false), "_8B62D3CA-5D03-4B2B-832B-126469288BB4")});
    }

    @Test
    public void testGetEmptyNodeInstancesFromResponse() throws JsonProcessingException {
        String emptyResults = "{ \"data\": { \"ProcessInstances\": [] }}";
        JsonNode response = this.objectMapper.readTree(emptyResults);
        List nodes = this.client.getNodeInstancesFromResponse(response);
        Assertions.assertThat((List)nodes).isEmpty();
    }

    @Test
    public void testGetNodeInstancesFromProcessInstanceOkResponse() {
        Mockito.when((Object)this.restTemplate.postForEntity((String)ArgumentMatchers.eq((Object)"data-indexURL/graphql"), ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(String.class), new Object[0])).thenReturn((Object)ResponseEntity.ok((Object)jsonString));
        List nodes = this.client.getNodeInstancesFromProcessInstance(this.PROCESS_INSTANCE_ID, "authHeader");
        ((ListAssert)Assertions.assertThat((List)nodes).hasSize(2)).containsExactly((Object[])new NodeInstance[]{new NodeInstance(Boolean.valueOf(true), "_9861B686-DF6B-4B1C-B370-F9898EEB47FD"), new NodeInstance(Boolean.valueOf(false), "_8B62D3CA-5D03-4B2B-832B-126469288BB4")});
    }

    @Test
    public void testGetNodeInstancesFromProcessInstance() {
        Mockito.when((Object)this.restTemplate.postForEntity((String)ArgumentMatchers.eq((Object)"data-indexURL/graphql"), ArgumentMatchers.any(HttpEntity.class), (Class)ArgumentMatchers.eq(String.class), new Object[0])).thenThrow(HttpClientErrorException.NotFound.class);
        Assertions.assertThatThrownBy(() -> this.client.getNodeInstancesFromProcessInstance(this.PROCESS_INSTANCE_ID, "authHeader")).isInstanceOf(ProcessSVGException.class);
    }

    @Test
    public void testAuthHeaderWithSecurityContext() {
        String token = "testToken";
        SecurityContext securityContextMock = (SecurityContext)Mockito.mock(SecurityContext.class);
        Authentication authenticationMock = (Authentication)Mockito.mock(Authentication.class);
        KeycloakPrincipal principalMock = (KeycloakPrincipal)Mockito.mock(KeycloakPrincipal.class);
        KeycloakSecurityContext keycloakSecurityContextMock = (KeycloakSecurityContext)Mockito.mock(KeycloakSecurityContext.class);
        Mockito.when((Object)securityContextMock.getAuthentication()).thenReturn((Object)authenticationMock);
        Mockito.when((Object)authenticationMock.getPrincipal()).thenReturn((Object)principalMock);
        Mockito.when((Object)principalMock.getKeycloakSecurityContext()).thenReturn((Object)keycloakSecurityContextMock);
        Mockito.when((Object)keycloakSecurityContextMock.getTokenString()).thenReturn((Object)token);
        SecurityContextHolder.setContext((SecurityContext)securityContextMock);
        this.client.setKeycloakAdapterAvailable(true);
        Assertions.assertThat((String)this.client.getAuthHeader("")).isEqualTo("Bearer " + token);
    }

    @Test
    public void testAuthHeaderWithoutKeycloakSecurityContext() {
        String authHeader = "Bearer testToken";
        this.client.setKeycloakAdapterAvailable(false);
        Assertions.assertThat((String)this.client.getAuthHeader(authHeader)).isEqualTo(authHeader);
    }
}

