/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import org.kie.kogito.tracing.EventEmitter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
public class SpringBootTraceEventEmitter
implements EventEmitter {
    private final KafkaTemplate<String, String> template;
    private final String kafkaTopicName;

    @Autowired
    public SpringBootTraceEventEmitter(KafkaTemplate<String, String> template, @Value(value="${kogito.addon.tracing.decision.kafka.topic.name:kogito-tracing-decision}") String kafkaTopicName) {
        this.template = template;
        this.kafkaTopicName = kafkaTopicName;
    }

    public void emit(String payload) {
        this.template.send(this.kafkaTopicName, (Object)payload);
    }
}

