/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.dmn.api.core.event.DMNRuntimeEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.config.ConfigBean;
import org.kie.kogito.config.StaticConfigBean;
import org.kie.kogito.decision.DecisionModel;
import org.kie.kogito.decision.DecisionModels;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingCollector;
import org.kie.kogito.tracing.decision.SpringBootDecisionTracingListener;
import org.kie.kogito.tracing.decision.SpringBootTraceEventEmitter;
import org.kie.kogito.tracing.decision.event.evaluate.EvaluateEvent;
import org.kie.kogito.tracing.event.trace.TraceEvent;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.kafka.core.KafkaTemplate;

public abstract class BaseSpringBootDecisionTracingTest {
    private static final String TEST_EXECUTION_ID = "7c50581e-6e5b-407b-91d6-2ffb1d47ebc0";
    private static final String TEST_SERVICE_URL = "localhost:8080";
    private static final String TEST_KAFKA_TOPIC = "kogito-tracing-decision";
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    private final String TEST_RESOURCE = "/" + this.getTestModelName() + ".dmn";

    protected abstract String getTestModelName();

    protected abstract String getTestModelNameSpace();

    protected abstract Map<String, Object> getContextVariables();

    protected abstract int getEvaluationEventCount();

    @Test
    void testAsyncListenerAndCollectorWithRealEventsIsWorking() throws IOException {
        DMNRuntime runtime = this.buildDMNRuntime();
        DecisionModel model = this.buildDecisionModel(runtime);
        List<EvaluateEvent> events = this.testListener(true, runtime, model);
        this.testCollector(events, model);
    }

    @Test
    void testSyncListenerAndCollectorWithRealEventsIsWorking() throws IOException {
        DMNRuntime runtime = this.buildDMNRuntime();
        DecisionModel model = this.buildDecisionModel(runtime);
        List<EvaluateEvent> events = this.testListener(false, runtime, model);
        this.testCollector(events, model);
    }

    private DMNRuntime buildDMNRuntime() {
        return DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(BaseSpringBootDecisionTracingTest.class.getResourceAsStream(this.TEST_RESOURCE))});
    }

    private DecisionModel buildDecisionModel(DMNRuntime runtime) {
        return new DmnDecisionModel(runtime, this.getTestModelNameSpace(), this.getTestModelName(), () -> TEST_EXECUTION_ID);
    }

    private List<EvaluateEvent> testListener(boolean asyncEnabled, DMNRuntime runtime, DecisionModel model) {
        ApplicationEventPublisher mockedEventPublisher = (ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class);
        SpringBootDecisionTracingCollector mockedCollector = (SpringBootDecisionTracingCollector)Mockito.mock(SpringBootDecisionTracingCollector.class);
        SpringBootDecisionTracingListener listener = new SpringBootDecisionTracingListener(mockedEventPublisher, mockedCollector, asyncEnabled);
        runtime.addListener((DMNRuntimeEventListener)listener);
        DMNContext context = model.newContext(this.getContextVariables());
        model.evaluateAll(context);
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EvaluateEvent.class);
        if (asyncEnabled) {
            ((ApplicationEventPublisher)Mockito.verify((Object)mockedEventPublisher, (VerificationMode)Mockito.times((int)this.getEvaluationEventCount()))).publishEvent(eventCaptor.capture());
            ((SpringBootDecisionTracingCollector)Mockito.verify((Object)mockedCollector, (VerificationMode)Mockito.never())).onApplicationEvent((EvaluateEvent)ArgumentMatchers.any());
        } else {
            ((ApplicationEventPublisher)Mockito.verify((Object)mockedEventPublisher, (VerificationMode)Mockito.never())).publishEvent((ApplicationEvent)ArgumentMatchers.any());
            ((SpringBootDecisionTracingCollector)Mockito.verify((Object)mockedCollector, (VerificationMode)Mockito.times((int)this.getEvaluationEventCount()))).onApplicationEvent((EvaluateEvent)eventCaptor.capture());
        }
        return eventCaptor.getAllValues();
    }

    private void testCollector(List<EvaluateEvent> events, DecisionModel model) throws IOException {
        DecisionModels mockedDecisionModels = (DecisionModels)Mockito.mock(DecisionModels.class);
        Mockito.when((Object)mockedDecisionModels.getDecisionModel(this.getTestModelNameSpace(), this.getTestModelName())).thenReturn((Object)model);
        Application mockedApplication = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)mockedApplication.get((Class)ArgumentMatchers.any())).thenReturn((Object)mockedDecisionModels);
        StaticConfigBean configBean = new StaticConfigBean(TEST_SERVICE_URL, true, null);
        KafkaTemplate mockedTemplate = (KafkaTemplate)Mockito.mock(KafkaTemplate.class);
        SpringBootTraceEventEmitter eventEmitter = new SpringBootTraceEventEmitter(mockedTemplate, TEST_KAFKA_TOPIC);
        SpringBootDecisionTracingCollector collector = new SpringBootDecisionTracingCollector(eventEmitter, (ConfigBean)configBean, mockedApplication);
        events.forEach(arg_0 -> ((SpringBootDecisionTracingCollector)collector).onApplicationEvent(arg_0));
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((KafkaTemplate)Mockito.verify((Object)mockedTemplate)).send((String)ArgumentMatchers.eq((Object)TEST_KAFKA_TOPIC), (Object)((String)payloadCaptor.capture()));
        CloudEvent cloudEvent = (CloudEvent)CloudEventUtils.decode((String)((String)payloadCaptor.getValue())).orElseThrow(() -> new IllegalStateException("Can't decode CloudEvent"));
        Assertions.assertEquals((Object)TEST_EXECUTION_ID, (Object)cloudEvent.getId());
        Assertions.assertNotNull((Object)cloudEvent.getData());
        TraceEvent traceEvent = (TraceEvent)MAPPER.readValue(cloudEvent.getData().toBytes(), TraceEvent.class);
        Assertions.assertNotNull((Object)traceEvent);
        Assertions.assertEquals((Object)TEST_SERVICE_URL, (Object)traceEvent.getHeader().getResourceId().getServiceUrl());
    }
}

