/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.jackson.JsonFormat;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.KogitoGAV;
import org.kie.kogito.decision.DecisionModelMetadata;
import org.kie.kogito.decision.DecisionModelResource;
import org.kie.kogito.decision.DecisionModelResourcesProvider;
import org.kie.kogito.tracing.decision.SpringBootModelEventEmitter;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.kafka.core.KafkaTemplate;

public class SpringBootModelEventEmitterTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    private static final String TEST_TOPIC = "test-topic";

    @Test
    public void testEmitEvent() throws JsonProcessingException {
        KafkaTemplate mockedKarkaTemplate = (KafkaTemplate)Mockito.mock(KafkaTemplate.class);
        List<DecisionModelResource> models = Arrays.asList(this.makeModel(), this.makeModel());
        DecisionModelResourcesProvider mockedDecisionModelResourcesProvider = () -> models;
        SpringBootModelEventEmitter eventEmitter = new SpringBootModelEventEmitter(mockedDecisionModelResourcesProvider, mockedKarkaTemplate, TEST_TOPIC);
        eventEmitter.publishDecisionModels();
        ArgumentCaptor topicCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor payloadCaptor = ArgumentCaptor.forClass(String.class);
        ((KafkaTemplate)Mockito.verify((Object)mockedKarkaTemplate, (VerificationMode)Mockito.times((int)2))).send((String)topicCaptor.capture(), (Object)((String)payloadCaptor.capture()));
        topicCaptor.getAllValues().forEach(v -> Assertions.assertEquals((Object)TEST_TOPIC, (Object)v));
        String rawCloudEvent1 = (String)payloadCaptor.getAllValues().get(0);
        String rawCloudEvent2 = (String)payloadCaptor.getAllValues().get(1);
        CloudEvent cloudEvent1 = (CloudEvent)OBJECT_MAPPER.readValue(rawCloudEvent1, CloudEvent.class);
        CloudEvent cloudEvent2 = (CloudEvent)OBJECT_MAPPER.readValue(rawCloudEvent2, CloudEvent.class);
        Assertions.assertEquals((Object)"id", (Object)cloudEvent1.getId());
        Assertions.assertEquals((Object)"id", (Object)cloudEvent2.getId());
    }

    private DecisionModelResource makeModel() {
        DecisionModelResource model = (DecisionModelResource)Mockito.mock(DecisionModelResource.class);
        Mockito.when((Object)model.getGav()).thenReturn((Object)new KogitoGAV("groupId", "artifactId", "version"));
        Mockito.when((Object)model.getModelName()).thenReturn((Object)"name");
        Mockito.when((Object)model.getNamespace()).thenReturn((Object)"namespace");
        Mockito.when((Object)model.getModelMetadata()).thenReturn((Object)new DecisionModelMetadata("http://www.omg.org/spec/DMN/20151101/dmn.xsd"));
        Mockito.when((Object)((String)model.get())).thenReturn((Object)"model");
        return model;
    }
}

