/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.tracing.decision.event;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNType;
import org.kie.dmn.feel.lang.types.BuiltInType;
import org.kie.kogito.tracing.decision.event.EventUtils;
import org.kie.kogito.tracing.decision.event.message.InternalMessageType;
import org.kie.kogito.tracing.typedvalue.TypedValue;
import org.mockito.Mockito;

class EventUtilsTest {
    EventUtilsTest() {
    }

    @Test
    void testDoesNotThrowOnNullValues() {
        Assertions.assertDoesNotThrow(() -> EventUtils.map(null, null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageFrom((DMNMessage)null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageFrom((InternalMessageType)null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageFrom(null, null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageExceptionFieldFrom(null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageFEELEventFrom(null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageFEELEventSeverityFrom(null));
        Assertions.assertDoesNotThrow(() -> EventUtils.messageLevelFrom(null));
        Assertions.assertDoesNotThrow(() -> EventUtils.traceResourceIdFrom(null, null));
        Assertions.assertDoesNotThrow(() -> EventUtils.typedValueFrom(null));
        Assertions.assertDoesNotThrow(() -> EventUtils.typedValueFrom(null, null));
    }

    @Test
    void testTypedVariableFromJsonNode() throws JsonProcessingException {
        ObjectReader reader = new ObjectMapper().reader();
        TypedValue value = EventUtils.typedValueFromJsonNode(null, null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.UNKNOWN.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("true"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.BOOLEAN.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("12"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.NUMBER.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("\"test\""), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.STRING.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("[1,2,3]"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.COLLECTION, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.LIST.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((JsonNode)reader.readTree("{\"name\": \"John\", \"age\": 45, \"married\": true}"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.STRUCTURE, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.UNKNOWN.getName(), (Object)value.getType());
    }

    @Test
    void testTypedVariableFromJsonNodeWithDMNType() throws JsonProcessingException {
        ObjectReader reader = new ObjectMapper().reader();
        TypedValue value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("Any"), null, null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.UNKNOWN.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("boolean"), (JsonNode)reader.readTree("true"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.BOOLEAN.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("number"), (JsonNode)reader.readTree("12"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.NUMBER.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("string"), (JsonNode)reader.readTree("\"test\""), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.UNIT, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.STRING.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("number"), (JsonNode)reader.readTree("[1,2,3]"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.COLLECTION, (Object)value.getKind());
        Assertions.assertEquals((Object)BuiltInType.NUMBER.getName(), (Object)value.getType());
        value = EventUtils.typedValueFromJsonNode((DMNType)this.mockDMNType("Person"), (JsonNode)reader.readTree("{\"name\": \"John\", \"age\": 45, \"married\": true}"), null);
        Assertions.assertNotNull((Object)value);
        Assertions.assertSame((Object)TypedValue.Kind.STRUCTURE, (Object)value.getKind());
        Assertions.assertEquals((Object)"Person", (Object)value.getType());
    }

    private DMNType mockDMNType(String name) {
        DMNType mock = (DMNType)Mockito.mock(DMNType.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }
}

