/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.common;

import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.DefaultCastable;
import org.kie.kogito.incubation.common.InternalObjectMapper;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MapLikeDataContext;

public class DataContextTest {
    @Test
    public void fromMap() {
        MapDataContext ctx = MapDataContext.create();
        ctx.set("firstName", (Object)"Paul");
        ctx.set("lastName", (Object)"McCartney");
        User u = (User)ctx.as(User.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)u.firstName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)u.lastName);
    }

    @Test
    public void toMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        MapLikeDataContext ctx = (MapLikeDataContext)u.as(MapLikeDataContext.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)ctx.get("firstName"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)ctx.get("lastName"));
        MapLikeDataContext ctx2 = (MapLikeDataContext)u.as(MapDataContext.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Paul", (Object)ctx2.get("firstName"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"McCartney", (Object)ctx2.get("lastName"));
    }

    @Test
    public void nestedValue() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext ctx = (MapDataContext)u.as(MapDataContext.class);
        org.junit.jupiter.api.Assertions.assertNotEquals(Address.class, ctx.get("addr").getClass());
        Address addr = (Address)InternalObjectMapper.convertValue((Object)ctx.get("addr"), Address.class);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Abbey Rd.", (Object)addr.street);
    }

    @Test
    public void getTypedValueFromMap() {
        User u = new User();
        u.firstName = "Paul";
        u.lastName = "McCartney";
        u.addr = new Address();
        u.addr.street = "Abbey Rd.";
        MapDataContext mdc = MapDataContext.of(Map.of("Paul", u));
        User paul = (User)mdc.get("Paul");
        User user = (User)mdc.get("Paul", User.class);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)user);
        org.junit.jupiter.api.Assertions.assertEquals((Object)paul, (Object)user);
    }

    @Test
    public void testFastAsUsingCast() {
        MapDataContext ctx = new MapDataContext(Map.of("full name", "John Doe", "age", 47));
        MapDataContext converted = (MapDataContext)ctx.as(MapDataContext.class);
        Assertions.assertThat((Object)converted).isSameAs((Object)ctx);
    }

    public static class User
    implements DataContext,
    DefaultCastable {
        String firstName;
        String lastName;
        Address addr;

        public boolean equals(Object o) {
            if (o instanceof User) {
                User user = (User)o;
                return Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.addr, user.addr);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.firstName, this.lastName, this.addr);
        }
    }

    public static class Address {
        String street;

        public boolean equals(Object o) {
            return o instanceof Address && Objects.equals(((Address)o).street, this.street);
        }
    }
}

