/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.predictions.services;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.application.ReflectiveAppRoot;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.DefaultCastable;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.predictions.LocalPredictionId;
import org.kie.kogito.incubation.predictions.PredictionIds;
import org.kie.kogito.incubation.predictions.services.PredictionService;

public class TestTypes {
    @Test
    public void testDecisionEvaluationService() {
        PredictionService svc = new PredictionService(){

            public ExtendedDataContext evaluate(LocalId id, DataContext ctx) {
                return ExtendedDataContext.ofData((DataContext)ctx);
            }
        };
        MapDataContext ctx = MapDataContext.create();
        String modelName = "/mypath/to/somePrediction.pmml";
        ReflectiveAppRoot appRoot = new ReflectiveAppRoot();
        LocalPredictionId decisionId = ((PredictionIds)appRoot.get(PredictionIds.class)).get(modelName);
        Assertions.assertEquals((Object)"/predictions/%2Fmypath%2Fto%2FsomePrediction.pmml", (Object)decisionId.toLocalId().asLocalUri().path());
        ctx.set("someParam", (Object)1);
        ExtendedDataContext result = svc.evaluate((LocalId)decisionId, (DataContext)ctx);
        MyDataContext mdc = (MyDataContext)result.as(MyDataContext.class);
        Assertions.assertEquals((int)1, (int)mdc.someParam);
    }

    public static class MyDataContext
    implements DataContext,
    DefaultCastable {
        int someParam;
    }
}

