/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.predictions.services;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.application.ReflectiveAppRoot;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.DefaultCastable;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.predictions.LocalPredictionId;
import org.kie.kogito.incubation.predictions.PredictionIds;
import org.kie.kogito.incubation.predictions.services.PredictionService;

public class TestTypes {
    @Test
    public void testDecisionEvaluationService() {
        PredictionService svc = new PredictionService(){

            public ExtendedDataContext evaluate(LocalId id, DataContext ctx) {
                return ExtendedDataContext.ofData((DataContext)ctx);
            }
        };
        MapDataContext ctx = MapDataContext.create();
        String fileNameNoSuffix = "somePrediction";
        String fileName = fileNameNoSuffix + ".pmml";
        String modelName = "/mypath/to/" + fileName;
        ReflectiveAppRoot appRoot = new ReflectiveAppRoot();
        LocalPredictionId decisionId = ((PredictionIds)appRoot.get(PredictionIds.class)).get(fileNameNoSuffix, modelName);
        Assertions.assertThat((String)decisionId.toLocalId().asLocalUri().path()).isEqualTo("/predictions/%2Fmypath%2Fto%2FsomePrediction.pmml");
        ctx.set("someParam", (Object)1);
        ExtendedDataContext result = svc.evaluate((LocalId)decisionId, (DataContext)ctx);
        MyDataContext mdc = (MyDataContext)result.as(MyDataContext.class);
        Assertions.assertThat((int)mdc.someParam).isOne();
    }

    public static class MyDataContext
    implements DataContext,
    DefaultCastable {
        int someParam;
    }
}

