/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes.services;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.DataContext;
import org.kie.kogito.incubation.common.DefaultCastable;
import org.kie.kogito.incubation.common.EmptyDataContext;
import org.kie.kogito.incubation.common.ExtendedDataContext;
import org.kie.kogito.incubation.common.Id;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.common.MapDataContext;
import org.kie.kogito.incubation.common.MapLikeDataContext;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.TaskId;
import org.kie.kogito.incubation.processes.services.StatefulProcessService;
import org.kie.kogito.incubation.processes.services.StraightThroughProcessService;

public class ProcessServiceTypeTest {
    @Test
    public void straightThroughProcesses() {
        StraightThroughProcessService svc = new StraightThroughProcessService(){

            public DataContext evaluate(Id id, DataContext ctx) {
                return ctx;
            }
        };
        MapDataContext ctx = MapDataContext.create();
        LocalProcessId someProcessId = new LocalProcessId("some.process");
        ctx.set("someParam", (Object)1);
        DataContext result = svc.evaluate((Id)someProcessId, (DataContext)ctx);
        MyDataContext mdc = (MyDataContext)result.as(MyDataContext.class);
        MapLikeDataContext map = (MapLikeDataContext)mdc.as(MapLikeDataContext.class);
        Assertions.assertEquals((int)1, (int)mdc.someParam);
        Assertions.assertEquals((Object)1, (Object)map.get("someParam"));
        Assertions.assertEquals((Object)"/processes/some.process", (Object)someProcessId.toLocalId().asLocalUri().path());
    }

    @Test
    public void statefulProcesses() {
        StatefulProcessService svc = new StatefulProcessService(){

            public ExtendedDataContext signal(LocalId processId, DataContext dataContext) {
                return ExtendedDataContext.ofData((DataContext)EmptyDataContext.Instance);
            }

            public ExtendedDataContext create(LocalId processId, DataContext dataContext) {
                return ExtendedDataContext.ofData((DataContext)EmptyDataContext.Instance);
            }

            public ExtendedDataContext update(LocalId processId, DataContext dataContext) {
                return ExtendedDataContext.ofData((DataContext)EmptyDataContext.Instance);
            }

            public ExtendedDataContext abort(LocalId processId) {
                return ExtendedDataContext.ofData((DataContext)EmptyDataContext.Instance);
            }

            public ExtendedDataContext get(LocalId processId) {
                return ExtendedDataContext.ofData((DataContext)EmptyDataContext.Instance);
            }
        };
        MapDataContext ctx = MapDataContext.create();
        LocalProcessId someProcessId = new LocalProcessId("some.process");
        ctx.set("someParam", (Object)1);
        ExtendedDataContext result = svc.create((LocalId)someProcessId, (DataContext)ctx);
        ProcessInstanceId processInstanceId = someProcessId.instances().get("some.instance.id");
        Assertions.assertEquals((Object)"/processes/some.process/instances/some.instance.id", (Object)processInstanceId.toLocalId().asLocalUri().path());
        TaskId taskId = processInstanceId.tasks().get("some.task.id");
        Assertions.assertEquals((Object)"/processes/some.process/instances/some.instance.id/tasks/some.task.id", (Object)taskId.toLocalId().asLocalUri().path());
    }

    public static class MyDataContext
    implements DataContext,
    DefaultCastable {
        int someParam;
    }
}

