/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.processes.AttachmentId;
import org.kie.kogito.incubation.processes.CommentId;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIdParser;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.SignalId;
import org.kie.kogito.incubation.processes.TaskId;
import org.kie.kogito.incubation.processes.TaskInstanceId;

public class ProcessIdParserTest {
    @Test
    public void testProcessId() {
        LocalProcessId processId = (LocalProcessId)ProcessIdParser.parse((String)"/processes/p", LocalProcessId.class);
        Assertions.assertEquals((Object)processId, (Object)new LocalProcessId("p"));
    }

    @Test
    public void testInvalidProcessId() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProcessIdParser.parse((String)"/processes", LocalProcessId.class));
    }

    @Test
    public void testProcessIdPart() {
        LocalProcessId processId = (LocalProcessId)ProcessIdParser.parse((String)"/processes/p/instances/pi", LocalProcessId.class);
        Assertions.assertEquals((Object)processId, (Object)new LocalProcessId("p"));
    }

    @Test
    public void testProcessInstanceId() {
        ProcessInstanceId instanceId = (ProcessInstanceId)ProcessIdParser.parse((String)"/processes/p/instances/pi", ProcessInstanceId.class);
        Assertions.assertEquals((Object)instanceId, (Object)new LocalProcessId("p").instances().get("pi"));
    }

    @Test
    public void testInvalidProcessInstanceId() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> ProcessIdParser.parse((String)"/processes/p", ProcessInstanceId.class));
    }

    @Test
    public void testTaskId() {
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)"/processes/p/instances/pi/tasks/t", TaskId.class);
        Assertions.assertEquals((Object)taskId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t"));
    }

    @Test
    public void testCommentId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti/comments/c";
        CommentId commentId = (CommentId)ProcessIdParser.parse((String)id, CommentId.class);
        Assertions.assertEquals((Object)commentId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti").comments().get("c"));
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertEquals((Object)taskId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t"));
    }

    @Test
    public void testTaskInstanceId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti";
        TaskInstanceId taskInstanceId = (TaskInstanceId)ProcessIdParser.parse((String)id, TaskInstanceId.class);
        Assertions.assertEquals((Object)taskInstanceId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti"));
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertEquals((Object)taskId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t"));
    }

    @Test
    public void testAttachmentId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti/attachments/a";
        AttachmentId attachmentId = (AttachmentId)ProcessIdParser.parse((String)id, AttachmentId.class);
        Assertions.assertEquals((Object)attachmentId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti").attachments().get("a"));
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertEquals((Object)taskId, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t"));
    }

    @Test
    public void testSignalId() {
        SignalId signalId = (SignalId)ProcessIdParser.parse((String)"/processes/p/instances/pi/signals/s", SignalId.class);
        Assertions.assertEquals((Object)signalId, (Object)new LocalProcessId("p").instances().get("pi").signals().get("s"));
    }

    @Test
    public void testLocalId() {
        LocalId id = ProcessIdParser.parse((String)"/processes/p/instances/pi/tasks/t", LocalId.class);
        Assertions.assertEquals((Object)id, (Object)new LocalProcessId("p").instances().get("pi").tasks().get("t"));
    }
}

