/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.incubation.processes;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;
import org.kie.kogito.incubation.common.LocalId;
import org.kie.kogito.incubation.processes.AttachmentId;
import org.kie.kogito.incubation.processes.CommentId;
import org.kie.kogito.incubation.processes.LocalProcessId;
import org.kie.kogito.incubation.processes.ProcessIdParser;
import org.kie.kogito.incubation.processes.ProcessInstanceId;
import org.kie.kogito.incubation.processes.SignalId;
import org.kie.kogito.incubation.processes.TaskId;
import org.kie.kogito.incubation.processes.TaskInstanceId;

public class ProcessIdParserTest {
    @Test
    public void testProcessId() {
        LocalProcessId processId = (LocalProcessId)ProcessIdParser.parse((String)"/processes/p", LocalProcessId.class);
        Assertions.assertThat((Object)new LocalProcessId("p")).isEqualTo((Object)processId);
    }

    @Test
    public void testInvalidProcessId() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ProcessIdParser.parse((String)"/processes", LocalProcessId.class));
    }

    @Test
    public void testProcessIdPart() {
        LocalProcessId processId = (LocalProcessId)ProcessIdParser.parse((String)"/processes/p/instances/pi", LocalProcessId.class);
        Assertions.assertThat((Object)new LocalProcessId("p")).isEqualTo((Object)processId);
    }

    @Test
    public void testProcessInstanceId() {
        ProcessInstanceId instanceId = (ProcessInstanceId)ProcessIdParser.parse((String)"/processes/p/instances/pi", ProcessInstanceId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi")).isEqualTo((Object)instanceId);
    }

    @Test
    public void testInvalidProcessInstanceId() {
        AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> ProcessIdParser.parse((String)"/processes/p", ProcessInstanceId.class));
    }

    @Test
    public void testTaskId() {
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)"/processes/p/instances/pi/tasks/t", TaskId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t")).isEqualTo((Object)taskId);
    }

    @Test
    public void testCommentId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti/comments/c";
        CommentId commentId = (CommentId)ProcessIdParser.parse((String)id, CommentId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti").comments().get("c")).isEqualTo((Object)commentId);
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t")).isEqualTo((Object)taskId);
    }

    @Test
    public void testTaskInstanceId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti";
        TaskInstanceId taskInstanceId = (TaskInstanceId)ProcessIdParser.parse((String)id, TaskInstanceId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti")).isEqualTo((Object)taskInstanceId);
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t")).isEqualTo((Object)taskId);
    }

    @Test
    public void testAttachmentId() {
        String id = "/processes/p/instances/pi/tasks/t/instances/ti/attachments/a";
        AttachmentId attachmentId = (AttachmentId)ProcessIdParser.parse((String)id, AttachmentId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t").instances().get("ti").attachments().get("a")).isEqualTo((Object)attachmentId);
        TaskId taskId = (TaskId)ProcessIdParser.parse((String)id, TaskId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t")).isEqualTo((Object)taskId);
    }

    @Test
    public void testSignalId() {
        SignalId signalId = (SignalId)ProcessIdParser.parse((String)"/processes/p/instances/pi/signals/s", SignalId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").signals().get("s")).isEqualTo((Object)signalId);
    }

    @Test
    public void testLocalId() {
        LocalId id = ProcessIdParser.parse((String)"/processes/p/instances/pi/tasks/t", LocalId.class);
        Assertions.assertThat((Object)new LocalProcessId("p").instances().get("pi").tasks().get("t")).isEqualTo((Object)id);
    }
}

