/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.util.Objects;
import java.util.UUID;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;
import org.kie.kogito.process.Process;

public class ProcessJobDescription
implements JobDescription {
    public static final Integer DEFAULT_PRIORITY = 5;
    private final String id = UUID.randomUUID().toString();
    private final ExpirationTime expirationTime;
    private final Integer priority;
    private String processId;
    private Process<?> process;

    private ProcessJobDescription(ExpirationTime expirationTime, Integer priority, String processId) {
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processId = Objects.requireNonNull(processId);
    }

    public ProcessJobDescription(ExpirationTime expirationTime, Integer priority, Process<?> process) {
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.process = Objects.requireNonNull(process);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExpirationTime expirationTime() {
        return this.expirationTime;
    }

    @Override
    public Integer priority() {
        return this.priority;
    }

    public String processId() {
        return this.processId;
    }

    public Process<?> process() {
        return this.process;
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, Process<?> process) {
        return new ProcessJobDescription(expirationTime, DEFAULT_PRIORITY, process);
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, String processId) {
        return ProcessJobDescription.of(expirationTime, DEFAULT_PRIORITY, processId);
    }

    public static ProcessJobDescription of(ExpirationTime expirationTime, Integer priority, String processId) {
        return new ProcessJobDescription(expirationTime, priority, processId);
    }
}

