/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.util.Map;
import java.util.function.Supplier;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.internal.utils.ServiceUtil;

public class ServiceRegistryImpl
implements ServiceRegistry {
    private static final String DYNAMIC_IMPL = "org.drools.dynamic.common.DynamicServiceRegistrySupplier";
    private static final String STATIC_IMPL = "org.drools.statics.common.StaticServiceRegistrySupplier";
    private static Supplier<ServiceRegistry> supplier = (Supplier)ServiceUtil.instanceFromNames("org.drools.dynamic.common.DynamicServiceRegistrySupplier", "org.drools.statics.common.StaticServiceRegistrySupplier");
    private Map<String, Object> registry = ServiceDiscoveryImpl.getInstance().getServices();

    public synchronized void reset() {
        ServiceDiscoveryImpl.getInstance().reset();
    }

    public synchronized void reload() {
        this.registry = ServiceDiscoveryImpl.getInstance().getServices();
    }

    @Override
    public synchronized <T> T get(Class<T> cls) {
        Object service = this.registry.get(cls.getCanonicalName());
        return (T)(cls.isInstance(service) ? service : null);
    }

    public static ServiceRegistry getServiceRegistry() {
        return supplier.get();
    }
}

