/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.util.Objects;
import java.util.UUID;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobDescription;

public class ProcessInstanceJobDescription
implements JobDescription {
    public static final Integer DEFAULT_PRIORITY = 5;
    private final String id;
    private final ExpirationTime expirationTime;
    private final Integer priority;
    private final String processInstanceId;
    private final String rootProcessInstanceId;
    private final String processId;
    private final String rootProcessId;

    private ProcessInstanceJobDescription(long timerId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String rootProcessId) {
        this.id = UUID.randomUUID().toString() + "_" + timerId;
        this.expirationTime = Objects.requireNonNull(expirationTime);
        this.priority = Objects.requireNonNull(priority);
        this.processInstanceId = Objects.requireNonNull(processInstanceId);
        this.rootProcessInstanceId = rootProcessInstanceId;
        this.processId = processId;
        this.rootProcessId = rootProcessId;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ExpirationTime expirationTime() {
        return this.expirationTime;
    }

    @Override
    public Integer priority() {
        return this.priority;
    }

    public String processInstanceId() {
        return this.processInstanceId;
    }

    public String rootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public String processId() {
        return this.processId;
    }

    public String rootProcessId() {
        return this.rootProcessId;
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, String processInstanceId, String processId) {
        return ProcessInstanceJobDescription.of(timerId, expirationTime, processInstanceId, null, processId, null);
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, String processInstanceId, String rootProcessInstanceId, String processId, String rootProcessId) {
        return ProcessInstanceJobDescription.of(timerId, expirationTime, DEFAULT_PRIORITY, processInstanceId, rootProcessInstanceId, processId, rootProcessId);
    }

    public static ProcessInstanceJobDescription of(long timerId, ExpirationTime expirationTime, Integer priority, String processInstanceId, String rootProcessInstanceId, String processId, String rootProcessId) {
        return new ProcessInstanceJobDescription(timerId, expirationTime, priority, processInstanceId, rootProcessInstanceId, processId, rootProcessId);
    }
}

