/*
 * Decompiled with CFR 0.152.
 */
package org.kie.api.internal.utils;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.internal.assembler.KieAssemblerService;
import org.kie.api.internal.utils.AnotherMockAssemblersImpl;
import org.kie.api.internal.utils.MockAssemblersImpl;
import org.kie.api.internal.utils.MockChildAssemblerService;
import org.kie.api.internal.utils.ServiceDiscoveryImpl;
import org.kie.api.io.ResourceType;

public class ServiceDiscoveryImplTest {
    @Test
    public void testServiceAndChildServiceInSameKieConf() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test0"));
        Map services = serviceDiscovery.getServices();
        Assertions.assertTrue((services.size() == 1 ? 1 : 0) != 0);
        Object service = ((List)services.get("org.kie.api.internal.assembler.KieAssemblers")).get(0);
        Assertions.assertNotNull(service);
        Assertions.assertTrue((boolean)(service instanceof MockAssemblersImpl));
        Map<ResourceType, KieAssemblerService> childServices = ((MockAssemblersImpl)service).getAssemblers();
        Assertions.assertTrue((childServices.size() == 1 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)childServices.get(ResourceType.DRL));
        Assertions.assertTrue((boolean)(childServices.get(ResourceType.DRL) instanceof MockChildAssemblerService));
    }

    @Test
    public void testDuplicatedServiceShouldFail() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        try {
            serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test1"));
            serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test2"));
            serviceDiscovery.getServices();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLoadServiceWithHighestPriority() {
        ServiceDiscoveryImpl serviceDiscovery = new ServiceDiscoveryImpl();
        ClassLoader cl = ServiceDiscoveryImplTest.class.getClassLoader();
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test3"));
        serviceDiscovery.registerConfs(cl, this.getUrl(cl, "META-INF/kie.conf.test1"));
        Map services = serviceDiscovery.getServices();
        List service = (List)services.get("org.kie.api.internal.assembler.KieAssemblers");
        Assertions.assertNotNull((Object)service);
        Assertions.assertEquals((int)2, (int)service.size());
        Assertions.assertTrue((boolean)(service.get(0) instanceof AnotherMockAssemblersImpl));
        Assertions.assertTrue((boolean)(service.get(1) instanceof MockAssemblersImpl));
    }

    protected URL getUrl(ClassLoader cl, String resourceName) {
        try {
            return cl.getResources(resourceName).nextElement();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

