/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.utils;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.utils.ConversionUtils;

class ConversionUtilsTest {
    ConversionUtilsTest() {
    }

    @Test
    void testConvert() {
        Assertions.assertEquals((int)5, (Integer)((Integer)ConversionUtils.convert((Object)"5", Integer.class)));
        Assertions.assertFalse((boolean)((Boolean)ConversionUtils.convert((Object)"5", Boolean.class)));
    }

    @Test
    void testCamelCase() {
        Assertions.assertEquals((Object)"myappCreate", (Object)ConversionUtils.toCamelCase((String)"myapp.create"));
        Assertions.assertEquals((Object)"getByName1", (Object)ConversionUtils.toCamelCase((String)"getByName_1"));
        Assertions.assertNotEquals((Object)"myappcreate", (Object)ConversionUtils.toCamelCase((String)"myapp.create"));
    }

    @Test
    public void testConcatPaths() {
        String expected = "http:localhost:8080/pepe/pepa/pepi";
        Assertions.assertEquals((Object)"http:localhost:8080/pepe/pepa/pepi", (Object)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"/pepa/pepi"));
        Assertions.assertEquals((Object)"http:localhost:8080/pepe/pepa/pepi", (Object)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"pepa/pepi"));
        Assertions.assertEquals((Object)"http:localhost:8080/pepe/pepa/pepi", (Object)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"pepa/pepi"));
        Assertions.assertEquals((Object)"http:localhost:8080/pepe/pepa/pepi", (Object)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"/pepa/pepi"));
    }
}

