/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs;

import java.text.MessageFormat;
import java.text.ParseException;
import org.kie.kogito.jobs.JobId;

public class AsyncJobId
implements JobId<String, Object> {
    public static final String TYPE = "ASYNC";
    private static final String SIGNAL = "asyncTriggered";
    private static MessageFormat format = new MessageFormat("{0}:{1}");
    private String uuid;

    public AsyncJobId() {
    }

    public AsyncJobId(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String encode() {
        return format.format(new Object[]{TYPE, this.uuid});
    }

    @Override
    public String signal() {
        return "asyncTriggered:" + this.uuid;
    }

    public AsyncJobId decode(String value) {
        try {
            Object[] values = format.parse(value);
            this.uuid = (String)values[1];
            return this;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Object payload(Object ... parameters) {
        return null;
    }

    @Override
    public String correlationId() {
        return this.uuid;
    }
}

