/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.utils;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.utils.ConversionUtils;

class ConversionUtilsTest {
    ConversionUtilsTest() {
    }

    @Test
    void testConvert() {
        Assertions.assertThat((Integer)((Integer)ConversionUtils.convert((Object)"5", Integer.class))).isEqualTo(5);
        Assertions.assertThat((Boolean)((Boolean)ConversionUtils.convert((Object)"5", Boolean.class))).isFalse();
    }

    @Test
    void testCamelCase() {
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"myapp.create")).isEqualTo("myappCreate");
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"getByName_1")).isEqualTo("getByName1");
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"myapp.create")).isNotEqualTo((Object)"myappcreate");
    }

    @Test
    public void testConcatPaths() {
        String expected = "http:localhost:8080/pepe/pepa/pepi";
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"/pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"/pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
    }
}

