/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.internal.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.utils.ConversionUtils;

class ConversionUtilsTest {
    ConversionUtilsTest() {
    }

    @Test
    void testConvertBoolean() {
        Assertions.assertThat((Boolean)((Boolean)ConversionUtils.convert((Object)"true", Boolean.class))).isTrue();
        Assertions.assertThat((Boolean)((Boolean)ConversionUtils.convert((Object)"5", Boolean.class))).isFalse();
    }

    @Test
    void testConvertInteger() {
        Assertions.assertThat((Integer)((Integer)ConversionUtils.convert((Object)"5", Integer.class))).isEqualTo(5);
    }

    @Test
    void testConvertDouble() {
        Assertions.assertThat((Double)((Double)ConversionUtils.convert((Object)"10.54d", Double.class))).isEqualTo(10.54);
    }

    @Test
    void testConvertFloat() {
        Assertions.assertThat((Float)((Float)ConversionUtils.convert((Object)"10.54f", Float.class))).isEqualTo(10.54f);
    }

    @Test
    void testConvertLong() {
        Assertions.assertThat((Long)((Long)ConversionUtils.convert((Object)"1000000000", Long.class))).isEqualTo(1000000000L);
    }

    @Test
    void testConvertShort() {
        Assertions.assertThat((Short)((Short)ConversionUtils.convert((Object)"5", Short.class))).isEqualTo((short)5);
    }

    @Test
    void testConvertByte() {
        Assertions.assertThat((Byte)((Byte)ConversionUtils.convert((Object)"112", Byte.class))).isEqualTo((byte)112);
    }

    @Test
    void testConvertPerson() {
        Person person = new Person("Javi", 23);
        String personAsString = person.toString();
        Assertions.assertThat((Object)((Person)ConversionUtils.convert((Object)personAsString, Person.class))).isEqualTo((Object)person);
        Assertions.assertThat((Object)((PersonConstructor)ConversionUtils.convert((Object)personAsString, PersonConstructor.class))).isInstanceOf(PersonConstructor.class);
    }

    @Test
    void testCamelCase() {
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"myapp.create")).isEqualTo("myappCreate");
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"getByName_1")).isEqualTo("getByName1");
        Assertions.assertThat((String)ConversionUtils.toCamelCase((String)"myapp.create")).isNotEqualTo((Object)"myappcreate");
    }

    @Test
    public void testConcatPaths() {
        String expected = "http:localhost:8080/pepe/pepa/pepi";
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"/pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe/", (String)"pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
        Assertions.assertThat((String)ConversionUtils.concatPaths((String)"http:localhost:8080/pepe", (String)"/pepa/pepi")).isEqualTo("http:localhost:8080/pepe/pepa/pepi");
    }

    @Test
    public void testConvertToCollection() {
        Assertions.assertThat((Collection)ConversionUtils.convertToCollection((Object)"1,2,3", Integer.class)).isEqualTo(Arrays.asList(1, 2, 3));
    }

    static class PersonConstructor {
        public PersonConstructor(String str) {
        }
    }

    static class Person {
        private final String name;
        private final int age;

        public Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String toString() {
            return this.name + ";" + this.age;
        }

        public int hashCode() {
            return Objects.hash(this.age, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Person other = (Person)obj;
            return this.age == other.age && Objects.equals(this.name, other.name);
        }

        public static Person convert(String str) {
            String[] strs = str.split(";");
            return new Person(strs[0], Integer.parseInt(strs[1]));
        }
    }
}

