/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests;

import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventExtensions;
import io.cloudevents.core.provider.ExtensionProvider;
import io.quarkus.test.junit.QuarkusTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.cloudevents.CloudEventUtils;
import org.kie.kogito.cloudevents.extension.KogitoExtension;

@QuarkusTest
public class QuarkusKogitoExtensionInitializerTest {
    @Test
    public void test() {
        String eventJson = "{\n  \"specversion\": \"1.0\",\n  \"id\": \"SomeEventId\",\n  \"source\": \"SomeEventSource\",\n  \"type\": \"SomeEventType\",\n  \"kogitodmnmodelname\": \"Traffic Violation\",\n  \"kogitodmnmodelnamespace\": \"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF\",\n  \"data\": \"{}\"}";
        CloudEvent event = (CloudEvent)CloudEventUtils.decode((String)eventJson).orElseThrow(IllegalStateException::new);
        KogitoExtension kogitoExtension = (KogitoExtension)ExtensionProvider.getInstance().parseExtension(KogitoExtension.class, (CloudEventExtensions)event);
        Assertions.assertNotNull((Object)kogitoExtension, (String)"KogitoExtension not registered, please make sure bean org.kie.kogito.addon.cloudevents.quarkus.QuarkusKogitoExtensionInitializer has been loaded");
        Assertions.assertEquals((Object)"Traffic Violation", (Object)kogitoExtension.getDmnModelName());
        Assertions.assertEquals((Object)"https://github.com/kiegroup/drools/kie-dmn/_A4BCA8B8-CF08-433F-93B2-A2598F19ECFF", (Object)kogitoExtension.getDmnModelNamespace());
    }
}

