/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.quarkus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junitpioneer.jupiter.ClearSystemProperty;
import org.junitpioneer.jupiter.SetSystemProperty;
import org.kie.kogito.addon.cloudevents.AbstractTopicDiscovery;
import org.kie.kogito.addon.cloudevents.quarkus.QuarkusTopicDiscovery;
import org.kie.kogito.event.ChannelType;
import org.kie.kogito.event.CloudEventMeta;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.Topic;

class QuarkusTopicDiscoveryTest {
    QuarkusTopicDiscoveryTest() {
    }

    @Test
    @SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="mp.messaging.outgoing.processedtravellers.connector", value="smallrye-http"), @SetSystemProperty(key="mp.messaging.outgoing.processedtravellers.url", value="http://localhost:8080/"), @SetSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.connector", value="smallrye-kafka"), @SetSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.topic", value="mycooltopic")})
    void verifyTopicsWithPropertiesSet() {
        ArrayList<Topic> expectedTopics = new ArrayList<Topic>();
        expectedTopics.add(new Topic("processedtravellers", ChannelType.OUTGOING));
        expectedTopics.add(new Topic("mycooltopic", ChannelType.INCOMING));
        QuarkusTopicDiscovery discovery = new QuarkusTopicDiscovery();
        List topics = discovery.getTopics(Collections.emptyList());
        Assertions.assertThat((List)topics).hasSize(2);
        expectedTopics.forEach(e -> Assertions.assertThat((boolean)topics.stream().anyMatch(t -> t.getName().equals(e.getName()) && t.getType() == e.getType())).isTrue());
    }

    @Test
    @SetSystemProperty.SetSystemProperties(value={@SetSystemProperty(key="mp.messaging.outgoing.processedtravellers.connector", value="smallrye-http"), @SetSystemProperty(key="mp.messaging.outgoing.processedtravellers.url", value="http://localhost:8080/"), @SetSystemProperty(key="mp.messaging.outgoing.processedtravellers.topic", value="mycooltopic"), @SetSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.connector", value="smallrye-kafka"), @SetSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.topic", value="mycooltopic")})
    void verifyTopicsWithPropertiesSameTopic() {
        ArrayList<Topic> expectedTopics = new ArrayList<Topic>();
        expectedTopics.add(new Topic("mycooltopic", ChannelType.OUTGOING));
        expectedTopics.add(new Topic("mycooltopic", ChannelType.INCOMING));
        QuarkusTopicDiscovery discovery = new QuarkusTopicDiscovery();
        List topics = discovery.getTopics(Collections.emptyList());
        Assertions.assertThat((List)topics).hasSize(2);
        expectedTopics.forEach(e -> Assertions.assertThat((boolean)topics.stream().anyMatch(t -> t.getName().equals(e.getName()) && t.getType() == e.getType())).isTrue());
    }

    @Test
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.connector"), @ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.url"), @ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.topic"), @ClearSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.connector"), @ClearSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.topic")})
    void verifyTopicsWithNoPropertiesSet() {
        ArrayList<Topic> expectedTopics = new ArrayList<Topic>();
        expectedTopics.add(AbstractTopicDiscovery.DEFAULT_OUTGOING_CHANNEL);
        expectedTopics.add(AbstractTopicDiscovery.DEFAULT_INCOMING_CHANNEL);
        ArrayList<CloudEventMeta> eventsMeta = new ArrayList<CloudEventMeta>();
        eventsMeta.add(new CloudEventMeta("event1", "", EventKind.CONSUMED));
        eventsMeta.add(new CloudEventMeta("event2", "", EventKind.PRODUCED));
        QuarkusTopicDiscovery discovery = new QuarkusTopicDiscovery();
        List topics = discovery.getTopics(eventsMeta);
        Assertions.assertThat((List)topics).hasSize(2);
        expectedTopics.forEach(e -> Assertions.assertThat((boolean)topics.stream().anyMatch(t -> t.getName().equals(e.getName()) && t.getType() == e.getType())).isTrue());
    }

    @Test
    @ClearSystemProperty.ClearSystemProperties(value={@ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.connector"), @ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.url"), @ClearSystemProperty(key="mp.messaging.outgoing.processedtravellers.topic"), @ClearSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.connector"), @ClearSystemProperty(key="mp.messaging.incoming.kogito_incoming_stream.topic")})
    void verifyTopicsWithPropertiesAndChannels() {
        QuarkusTopicDiscovery discovery = new QuarkusTopicDiscovery();
        List topics = discovery.getTopics(Collections.emptyList());
        Assertions.assertThat((List)topics).isEmpty();
    }
}

