/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.event.DefaultAgendaEventListener;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.data.Account;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.rules.RuleConfig;
import org.kie.kogito.uow.UnitOfWork;

public class BusinessRuleTaskTest
extends AbstractCodegenTest {
    @Test
    public void testBasicBusinessRuleTask() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
    }

    @Test
    public void testBasicBusinessRuleTaskWithAgendaListener() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap);
        Assertions.assertThat((Object)app).isNotNull();
        final AtomicInteger counter = new AtomicInteger();
        ((RuleConfig)app.config().get(RuleConfig.class)).ruleEventListeners().agendaListeners().add(new DefaultAgendaEventListener(){

            public void afterMatchFired(AfterMatchFiredEvent event) {
                counter.incrementAndGet();
            }
        });
        Process p = ((Processes)app.get(Processes.class)).processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
    }

    @Test
    public void testBasicBusinessRuleTaskControlledByUnitOfWork() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("ruletask/BusinessRuleTask.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap);
        Assertions.assertThat((Object)app).isNotNull();
        final ArrayList startedProcesses = new ArrayList();
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        UnitOfWork uow = app.unitOfWorkManager().newUnitOfWork();
        uow.start();
        Process p = ((Processes)app.get(Processes.class)).processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        m.fromMap(Collections.singletonMap("person", new Person("john", 25)));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKey((Object)"person");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat(startedProcesses).hasSize(0);
        uow.end();
        Assertions.assertThat(startedProcesses).hasSize(1);
    }

    @Test
    public void testDecision() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("decision/models/dmnprocess.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.DECISION, Collections.singletonList("decision/models/vacationDaysAlt/vacationDaysAlt.dmn"));
        Application app = this.generateCode(resourcesTypeMap);
        Process p = ((Processes)app.get(Processes.class)).processById("DmnProcess");
        Model m = (Model)p.createModel();
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        vars.put("age", 16);
        vars.put("yearsOfService", 1);
        m.fromMap(vars);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(27L));
        m = (Model)p.createModel();
        vars = new HashMap();
        vars.put("age", 44);
        vars.put("yearsOfService", 20);
        m.fromMap(vars);
        processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(24L));
        m = (Model)p.createModel();
        vars = new HashMap();
        vars.put("age", 50);
        vars.put("yearsOfService", 30);
        m.fromMap(vars);
        processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("vacationDays")).isNotNull()).isEqualTo((Object)BigDecimal.valueOf(30L));
    }

    @Test
    public void testBusinessRuleTaskWithIOExpression() throws Exception {
        HashMap<AbstractCodegenTest.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenTest.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.PROCESS, Collections.singletonList("ruletask/BusinessRuleTaskWithIOExpression.bpmn2"));
        resourcesTypeMap.put(AbstractCodegenTest.TYPE.RULES, Collections.singletonList("ruletask/BusinessRuleTask.drl"));
        Application app = this.generateCode(resourcesTypeMap);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("BusinessRuleTask");
        Model m = (Model)p.createModel();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("person", new Person("john", 25));
        params.put("account", new Account());
        m.fromMap(params);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"person", "account"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("person")).isNotNull()).hasFieldOrPropertyWithValue("adult", (Object)true);
        Assertions.assertThat(result.toMap().get("account")).isNotNull();
        Assertions.assertThat((Object)((Account)result.toMap().get("account")).getPerson()).isNotNull();
    }
}

