/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.MessageEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenTest;
import org.kie.kogito.codegen.process.ProcessCodegenException;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.Sig;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class MessageIntermediateEventTest
extends AbstractCodegenTest {
    @Test
    public void testMessageEndEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/MessageEndEvent.bpmn2");
        ProcessEventListener listener = (ProcessEventListener)Mockito.mock(KogitoProcessEventListener.class);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("MessageEndEvent");
        Model m = (Model)p.createModel();
        m.update(Collections.singletonMap("x", "Javierito"));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        ArgumentCaptor messageEvent = ArgumentCaptor.forClass(MessageEvent.class);
        ((ProcessEventListener)Mockito.verify((Object)listener)).onMessage((MessageEvent)messageEvent.capture());
        Assertions.assertThat((String)((MessageEvent)messageEvent.getValue()).getMessageName()).isEqualTo("_2_Message");
        Assertions.assertThat((Object)((MessageEvent)messageEvent.getValue()).getMessage()).isEqualTo((Object)"Javierito");
    }

    @Test
    public void testMessageThrowEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/IntermediateThrowEventMessage.bpmn2");
        ProcessEventListener listener = (ProcessEventListener)Mockito.mock(KogitoProcessEventListener.class);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("MessageIntermediateEvent");
        Model m = (Model)p.createModel();
        m.update(Collections.singletonMap("customerId", "Javierito"));
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        ArgumentCaptor messageEvent = ArgumentCaptor.forClass(MessageEvent.class);
        ((ProcessEventListener)Mockito.verify((Object)listener)).onMessage((MessageEvent)messageEvent.capture());
        Assertions.assertThat((String)((MessageEvent)messageEvent.getValue()).getMessageName()).isEqualTo("customers");
        Assertions.assertThat((Object)((MessageEvent)messageEvent.getValue()).getMessage()).isEqualTo((Object)"Javierito");
    }

    @Test
    public void testMessageCatchEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/IntermediateCatchEventMessage.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("IntermediateCatchEvent");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"Message-customers", (Object)"CUS-00998877"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void testMessageBoundaryCatchEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messageevent/BoundaryMessageEventOnTask.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("BoundaryMessageOnTask");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        processInstance.send(Sig.of((String)"Message-customers", (Object)"CUS-00998877"));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void malformedShouldThrowException() {
        org.junit.jupiter.api.Assertions.assertThrows(ProcessCodegenException.class, () -> this.generateCodeProcessesOnly("messageevent/EventNodeMalformed.bpmn2"));
    }
}

