/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.time.SessionPseudoClock;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.data.Address;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.rules.RuleCodegenError;
import org.kie.kogito.codegen.rules.multiunit.MultiUnit;
import org.kie.kogito.codegen.rules.singleton.Datum;
import org.kie.kogito.codegen.rules.singleton.Singleton;
import org.kie.kogito.codegen.unit.AdultUnit;
import org.kie.kogito.codegen.unit.PersonsUnit;
import org.kie.kogito.rules.DataHandle;
import org.kie.kogito.rules.DataObserver;
import org.kie.kogito.rules.DataSource;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.RuleUnit;
import org.kie.kogito.rules.RuleUnitData;
import org.kie.kogito.rules.RuleUnitInstance;
import org.kie.kogito.rules.RuleUnits;

public class RuleUnitCompilerIT
extends AbstractCodegenIT {
    @Test
    public void testRuleUnit() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnit.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(instance.getClock() instanceof SessionPseudoClock));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance.fire());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
        sofia.setAge(22);
        adults.getPersons().update(dhSofia, (Object)sofia);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance.fire());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena", "Sofia")));
    }

    @Test
    public void testRuleUnitModify() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitModify.drl");
        AdultUnit adults = new AdultUnit();
        Person sofia = new Person("Sofia", 7);
        DataHandle dhSofia = adults.getPersons().add((Object)sofia);
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instance.fire());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)adults.getResults().getResults().containsAll(Arrays.asList("Sofia")));
    }

    @Test
    public void testRuleUnitDelete() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitDelete.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        instance.fire();
        List<String> results = adults.getResults().getResults();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)results.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testRuleUnitQuery() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitQuery.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        Class<?> queryClass = application.getClass().getClassLoader().loadClass("org.kie.kogito.codegen.unit.AdultUnitQueryFindAdults");
        List results = (List)instance.executeQuery(queryClass);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)results.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)results.containsAll(Arrays.asList("Mario", "Marilena")));
    }

    @Test
    public void testRuleUnitQueryOnPrimitive() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitQuery.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45));
        adults.getPersons().add((Object)new Person("Marilena", 47));
        adults.getPersons().add((Object)new Person("Sofia", 7));
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        List results = instance.executeQuery("FindAdultsAge").stream().map(m -> m.get("$age")).map(Integer.class::cast).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)results.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)results.containsAll(Arrays.asList(45, 47)));
    }

    @Test
    public void testRuleUnitQueryWithNoRules() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitQueryNoRules.drl");
        AdultUnit adults = new AdultUnit();
        adults.getPersons().add((Object)new Person("Mario", 45).setAdult(true));
        adults.getPersons().add((Object)new Person("Marilena", 47).setAdult(true));
        adults.getPersons().add((Object)new Person("Sofia", 7).setAdult(true));
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        List results = instance.executeQuery("FindAdultsAge").stream().map(m -> m.get("$sum")).map(Integer.class::cast).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertThat(results).containsExactlyInAnyOrder((Object[])new Integer[]{99});
    }

    @Test
    public void testRuleUnitExecutor() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnit.drl", "org/kie/kogito/codegen/unit/PersonsUnit.drl");
        DataStore persons = DataSource.createStore();
        persons.add((Object)new Person("Mario", 45));
        persons.add((Object)new Person("Marilena", 17));
        persons.add((Object)new Person("Sofia", 7));
        RuleUnit adultUnit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        AdultUnit adultData18 = new AdultUnit((DataStore<Person>)persons, 18);
        RuleUnitInstance adultUnitInstance18 = adultUnit.createInstance((RuleUnitData)adultData18, "adult18");
        AdultUnit adultData21 = new AdultUnit((DataStore<Person>)persons, 21);
        RuleUnitInstance adultUnitInstance21 = adultUnit.createInstance((RuleUnitData)adultData21, "adult21");
        RuleUnit personsUnit = ((RuleUnits)application.get(RuleUnits.class)).create(PersonsUnit.class);
        personsUnit.createInstance((RuleUnitData)new PersonsUnit((DataStore<Person>)persons)).fire();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)adultData18.getResults().getResults().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)adultData18.getResults().getResults().containsAll(Arrays.asList("Mario", "Marilena")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)adultData21.getResults().getResults().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)adultData21.getResults().getResults().containsAll(Arrays.asList("Mario")));
    }

    @Test
    public void generateSinglePackageSingleUnit() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/rules/multiunit/MultiUnit.drl", "org/kie/kogito/codegen/rules/multiunit/MultiUnit2.drl");
        ArrayList strings = new ArrayList();
        RuleUnit mu = ((RuleUnits)application.get(RuleUnits.class)).create(MultiUnit.class);
        MultiUnit data = new MultiUnit();
        RuleUnitInstance instance = mu.createInstance((RuleUnitData)data);
        data.getValues().subscribe(DataObserver.of(v -> {
            if (v != null) {
                strings.add((String)v);
            }
        }));
        data.getValues().add((Object)"start");
        instance.fire();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("start", "middle", "done"), strings);
    }

    @Test
    public void singletonStore() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/rules/singleton/Singleton.drl");
        ArrayList data = new ArrayList();
        AtomicReference lastSeen = new AtomicReference();
        RuleUnit mu = ((RuleUnits)application.get(RuleUnits.class)).create(Singleton.class);
        Singleton unitData = new Singleton();
        RuleUnitInstance instance = mu.createInstance((RuleUnitData)unitData);
        unitData.getOutput().subscribe(DataObserver.ofUpdatable(v -> data.add(v == null ? null : v.getValue())));
        unitData.getOutput().subscribe(DataObserver.of(lastSeen::set));
        unitData.getInput().set((Object)new Datum("start"));
        instance.fire();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("continue", "updated", null, "done"), data);
        ((Datum)lastSeen.get()).setValue("updated");
        unitData.getOutput().update();
        instance.fire();
        org.junit.jupiter.api.Assertions.assertEquals(Arrays.asList("continue", "updated", null, "done", "updated", null, "done"), data);
    }

    @Test
    public void test2PatternsOopath() throws Exception {
        Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/TwoPatternsQuery.drl");
        AdultUnit adults = new AdultUnit();
        Person mario = new Person("Mario", 42);
        mario.addAddress(new Address("Milano"));
        Person mark = new Person("Mark", 40);
        mark.addAddress(new Address("London"));
        Person edson = new Person("Edson", 37);
        edson.addAddress(new Address("Toronto"));
        adults.getPersons().add((Object)mario);
        adults.getPersons().add((Object)mark);
        adults.getPersons().add((Object)edson);
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        List results = instance.executeQuery("FindPeopleInMilano").stream().map(m -> m.get("$p")).map(Person.class::cast).collect(Collectors.toList());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)results.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Mario", (Object)((Person)results.get(0)).getName());
    }

    @Test
    public void testRuleUnitWithNoBindQueryShouldntCompile() throws Exception {
        try {
            Application application = this.generateCodeRulesOnly("org/kie/kogito/codegen/unit/RuleUnitNoBindQuery.drl");
            org.junit.jupiter.api.Assertions.fail((String)"A query without binding shouldn't compile");
        }
        catch (RuleCodegenError ruleCodegenError) {
            // empty catch block
        }
    }

    @Test
    public void testRuleUnitNoPropertyReactivity() throws Exception {
        this.checckPropertyReactvity(false);
    }

    @Test
    public void testRuleUnitWithPropertyReactivity() throws Exception {
        this.checckPropertyReactvity(true);
    }

    private void checckPropertyReactvity(boolean usePropertyReactivity) throws Exception {
        KogitoBuildContext context = this.newContext();
        if (!usePropertyReactivity) {
            context.setApplicationProperty("drools.propertySpecific", (Object)PropertySpecificOption.DISABLED.toString());
        }
        HashMap<AbstractCodegenIT.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenIT.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenIT.TYPE.RULES, Arrays.asList("org/kie/kogito/codegen/unit/RuleUnitNoPropReact.drl"));
        Application application = this.generateCode(resourcesTypeMap, context);
        AdultUnit adults = new AdultUnit();
        Person mario = new Person("Mario", 45);
        adults.getPersons().add((Object)mario);
        RuleUnit unit = ((RuleUnits)application.get(RuleUnits.class)).create(AdultUnit.class);
        RuleUnitInstance instance = unit.createInstance((RuleUnitData)adults);
        instance.fire();
        org.junit.jupiter.api.Assertions.assertEquals((int)(usePropertyReactivity ? 46 : 50), (int)mario.getAge());
    }
}

