/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

public class HelloService {
    int count = 0;

    public String hello(String name) {
        System.out.println("Service invoked with " + name.toString() + " on service " + this.toString());
        return "Hello " + name + "!";
    }

    public JsonNode jsonHello(JsonNode person) {
        System.out.println("Service invoked with " + person + " on service " + this.toString());
        String retJsonStr = "{\"result\":\"Hello " + person.get("name").textValue() + "\"}";
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.readTree(retJsonStr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String goodbye(String name) {
        System.out.println("Service invoked with " + name.toString() + " on service " + this.toString());
        return "Goodbye " + name + "!";
    }

    public String helloMulti(String name, String lastName) {
        System.out.println("Service invoked with " + name + " and " + lastName + " on service " + this.toString());
        return "Hello (first and lastname) " + name.toString() + " " + lastName + "!";
    }

    public void helloNoOutput(String name, Integer age) {
        System.out.println("Service invoked with " + name.toString() + " " + age + " on service " + this.toString());
    }

    public String helloOutput(String name, Integer age) {
        System.out.println("Service invoked with " + name.toString() + " " + age + " on service " + this.toString());
        return "Hello " + name + " " + age + "!";
    }

    public void doSomething(String str1) {
        if (this.count > 0) {
            throw new RuntimeException("You should not be here");
        }
        ++this.count;
    }

    public void doSomething(String str1, String str2) {
    }

    public void error(String errorType) {
        if ("error1".equals(errorType)) {
            System.out.println("Mocking Throw Error1 (IllegalArgumentException)");
            throw new IllegalArgumentException();
        }
        if ("error2".equals(errorType)) {
            System.out.println("Mocking Throw Error2 (RuntimeException)");
            throw new RuntimeException();
        }
        System.out.println("Mocking Throw Generic Error (UnsupportedOperationException)");
        throw new UnsupportedOperationException();
    }
}

