/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.io.CollectedResource;
import org.kie.kogito.codegen.openapi.client.OpenApiClientCodegen;
import org.kie.kogito.codegen.process.ProcessCodegen;

public class OpenApiClientServerlessWorkflowIT
extends AbstractCodegenIT {
    @ParameterizedTest
    @ValueSource(strings={"openapi/petstore-classpath.sw.json"})
    public void openApiSpecInClasspath(String resource) {
        KogitoBuildContext context = this.newContext();
        Collection<CollectedResource> resources = OpenApiClientServerlessWorkflowIT.toCollectedResources(Collections.singletonList(resource));
        OpenApiClientCodegen openApiClientCodegen = OpenApiClientCodegen.ofCollectedResources((KogitoBuildContext)context, resources);
        Assertions.assertThat((List)openApiClientCodegen.getOpenAPISpecResources()).isNotEmpty();
        Collection openApiGeneratedFiles = openApiClientCodegen.generate();
        Assertions.assertThat((Iterable)openApiGeneratedFiles).isNotEmpty();
        Assertions.assertThat((List)((List)context.getContextAttribute("openApiDescriptor", List.class))).isNotEmpty();
        ProcessCodegen processCodegen = ProcessCodegen.ofCollectedResources((KogitoBuildContext)context, resources);
        Collection processGeneratedFiles = processCodegen.generate();
        Assertions.assertThat((Iterable)processGeneratedFiles).isNotEmpty();
    }

    @Test
    public void testPetstoreOpenApiCodeGeneration() throws Exception {
        HashMap<AbstractCodegenIT.TYPE, List<String>> resourcesTypeMap = new HashMap<AbstractCodegenIT.TYPE, List<String>>();
        resourcesTypeMap.put(AbstractCodegenIT.TYPE.OPENAPI, Collections.singletonList("openapi/petstore-classpath.sw.json"));
        Application app = this.generateCode(resourcesTypeMap);
        Assertions.assertThat((Object)app).isNotNull();
    }
}

