/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.ProcessTestUtils;

class CompensationIT
extends AbstractCodegenIT {
    CompensationIT() {
    }

    @Test
    void testCompensateFirst() throws Exception {
        Application app = this.generateCodeProcessesOnly("compensation/compensateFirst.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("compensateFirst");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        Model model = (Model)processInstance.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)2, model.toMap().get("counter"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)1, model.toMap().get("counter2"));
    }

    @Test
    void testCompensateSecond() throws Exception {
        Application app = this.generateCodeProcessesOnly("compensation/compensateSecond.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("compensateSecond");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        Model model = (Model)processInstance.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)1, model.toMap().get("counter"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)2, model.toMap().get("counter2"));
    }

    @Test
    void testCompensateAll() throws Exception {
        Application app = this.generateCodeProcessesOnly("compensation/compensateAll.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("compensateAll");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        Model model = (Model)processInstance.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)2, model.toMap().get("counter"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)2, model.toMap().get("counter2"));
    }

    @Test
    void testThrowSpecificForSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("compensation/BPMN2-Compensation-ThrowSpecificForSubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("CompensationSpecificSubProcess");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        Model model = (Model)processInstance.variables();
        ProcessTestUtils.assertState(processInstance, 2);
        org.junit.jupiter.api.Assertions.assertNull(model.toMap().get("x"));
    }
}

