/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.ProcessTestUtils;

public class ErrorIT
extends AbstractCodegenIT {
    @Test
    void testBoundaryErrorSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("error/BoundaryErrorSubProcess.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        List<String> completedNodesNames = this.completedNodesListener(app);
        Process p = ((Processes)app.get(Processes.class)).processById("BoundaryErrorSubProcess");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        Assertions.assertThat(completedNodesNames).contains((Object[])new String[]{"Error2Task"});
    }

    @Test
    void testBoundaryErrorWithCode1() throws Exception {
        this.testBoundaryError("error1", "Error1Task");
    }

    @Test
    void testBoundaryErrorWithCode2() throws Exception {
        this.testBoundaryError("error2", "Error2Task");
    }

    @Test
    void testBoundaryErrorWithoutCode() throws Exception {
        this.testBoundaryError(null, "Error1Task", "Error2Task");
    }

    private void testBoundaryError(String errorType, String ... taskToAssert) throws Exception {
        Application app = this.generateCodeProcessesOnly("error/BoundaryError.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        List<String> completedNodesNames = this.completedNodesListener(app);
        Process p = ((Processes)app.get(Processes.class)).processById("BoundaryError");
        Model model = (Model)p.createModel();
        model.update(Collections.singletonMap("errorType", errorType));
        ProcessInstance processInstance = p.createInstance(model);
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        if (Objects.nonNull(errorType)) {
            ProcessTestUtils.assertState(processInstance, 2);
            Assertions.assertThat(completedNodesNames).contains((Object[])taskToAssert);
        } else {
            ProcessTestUtils.assertState(processInstance, 5);
            Assertions.assertThat(completedNodesNames).doesNotContain((Object[])taskToAssert);
        }
    }

    @Test
    void testEndError() throws Exception {
        Application app = this.generateCodeProcessesOnly("error/EndError.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        List<String> completedNodesNames = this.completedNodesListener(app);
        Process p = ((Processes)app.get(Processes.class)).processById("EndError");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 3);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)completedNodesNames.contains("task"));
    }

    @Test
    void testEndErrorWithEventSubprocess() throws Exception {
        this.testErrorInSubprocess("error/EndErrorWithEventSubprocess.bpmn2", "EndErrorWithEventSubprocess");
    }

    @Test
    void testEndErrorInSubprocessWithEventSubprocess() throws Exception {
        this.testErrorInSubprocess("error/EndErrorInSubprocessWithEventSubprocess.bpmn2", "EndErrorInSubprocessWithEventSubprocess");
    }

    private List<String> completedNodesListener(Application app) {
        final ArrayList<String> completedIds = new ArrayList<String>();
        this.addProcessEventListener(app, (KogitoProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                completedIds.add(event.getNodeInstance().getNodeName());
            }
        });
        return completedIds;
    }

    private void testErrorInSubprocess(String processPath, String processId) throws Exception {
        Application app = this.generateCodeProcessesOnly(processPath);
        Assertions.assertThat((Object)app).isNotNull();
        List<String> completedNames = this.completedNodesListener(app);
        Process p = ((Processes)app.get(Processes.class)).processById(processId);
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        ProcessTestUtils.assertState(processInstance, 0);
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)completedNames.containsAll(Arrays.asList("task", "subprocess-task")));
    }

    public void addProcessEventListener(Application app, KogitoProcessEventListener listener) {
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
    }
}

