/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;

public class MessageStartEventIT
extends AbstractCodegenIT {
    @Test
    public void testMessageStartEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messagestartevent/MessageStartEvent.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("MessageStartEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("customerId", "CUS-00998877");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start("customers", null);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void testMessageStartAndEndEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messagestartevent/MessageStartAndEndEvent.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("MessageStartEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("customerId", "CUS-00998877");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start("customers", null);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"customerId"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
    }

    @Test
    public void testNoneAndMessageStartEventProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("messagestartevent/NoneAndMessageStartEvent.bpmn2");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("MessageStartEvent");
        Model m = (Model)p.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("customerId", "CUS-00998877");
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"customerId", "path"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("path")).isNotNull()).isEqualTo((Object)"none");
        processInstance = p.createInstance(m);
        processInstance.start("customers", null);
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(2)).containsKeys((Object[])new String[]{"customerId", "path"});
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("customerId")).isNotNull()).isEqualTo((Object)"CUS-00998877");
        ((ObjectAssert)Assertions.assertThat(result.toMap().get("path")).isNotNull()).isEqualTo((Object)"message");
    }
}

