/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;

public class ServerlessWorkflowIT
extends AbstractCodegenIT {
    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation.sw.json", "serverless/single-operation.sw.yml"})
    public void testSingleFunctionCallWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation-with-delay.sw.json", "serverless/single-operation-with-delay.sw.yml"})
    public void testSingleFunctionCallWithDelayWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        NodeLeftCountDownProcessEventListener listener = new NodeLeftCountDownProcessEventListener("SmallDelay", 1);
        ((ProcessConfig)app.config().get(ProcessConfig.class)).processEventListeners().listeners().add(listener);
        Process p = ((Processes)app.get(Processes.class)).processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        boolean completed = listener.waitTillCompleted(5000L);
        Assertions.assertThat((boolean)completed).isTrue();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation-many-functions.sw.json", "serverless/single-operation-many-functions.sw.yml"})
    public void testMultipleFunctionsCallWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-operation-no-actions.sw.json", "serverless/single-operation-no-actions.sw.yml"})
    public void testNoActionOperationStateWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("noactions");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/multiple-operations.sw.json", "serverless/multiple-operations.sw.yml"})
    public void testMultipleOperationsWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("function");
        Model m = (Model)p.createModel();
        HashMap parameters = new HashMap();
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-service-operation.sw.json", "serverless/single-service-operation.sw.yml"})
    public void testBasicServiceWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("singleservice");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{\n  \"name\": \"john\"\n}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("result").textValue()).isEqualTo("Hello john");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/single-inject-state.sw.json", "serverless/single-inject-state.sw.yml"})
    public void testSingleInjectWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("singleinject");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("name").textValue()).isEqualTo("john");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/switch-state.sw.json", "serverless/switch-state.sw.yml"})
    public void testApproveSwitchStateWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("switchworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("decision").textValue()).isEqualTo("Approved");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/switch-state-deny.sw.json", "serverless/switch-state-deny.sw.yml"})
    public void testDenySwitchStateWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("switchworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("decision").textValue()).isEqualTo("Denied");
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/switch-state-end-condition.sw.json", "serverless/switch-state-end-condition.sw.yml"})
    public void testSwitchStateWithEndConditionWorkflow(String processLocation) throws Exception {
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("switchworkflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }

    @Test
    public void testSubFlowWorkflow() throws Exception {
        Application app = this.generateCodeProcessesOnly("serverless/single-subflow.sw.json", "serverless/called-subflow.sw.json");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("singlesubflow");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        Model result = (Model)processInstance.variables();
        ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
        Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
        JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
        Assertions.assertThat((String)dataOut.get("parentData").textValue()).isEqualTo("parentTestData");
        Assertions.assertThat((String)dataOut.get("childData").textValue()).isEqualTo("childTestData");
    }

    @Test
    public void testParallelExecWorkflow() throws Exception {
        try {
            Application app = this.generateCodeProcessesOnly("serverless/parallel-state.sw.json", "serverless/parallel-state-branch1.sw.json", "serverless/parallel-state-branch2.sw.json");
            Assertions.assertThat((Object)app).isNotNull();
            Process p = ((Processes)app.get(Processes.class)).processById("parallelworkflow");
            Model m = (Model)p.createModel();
            HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
            String jsonParamStr = "{}";
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
            parameters.put("workflowdata", jsonParamObj);
            m.fromMap(parameters);
            ProcessInstance processInstance = p.createInstance(m);
            processInstance.start();
            Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
            Model result = (Model)processInstance.variables();
            ((MapAssert)Assertions.assertThat((Map)result.toMap()).hasSize(1)).containsKeys((Object[])new String[]{"workflowdata"});
            Assertions.assertThat(result.toMap().get("workflowdata")).isInstanceOf(JsonNode.class);
            JsonNode dataOut = (JsonNode)result.toMap().get("workflowdata");
            Assertions.assertThat((String)dataOut.get("branch1data").textValue()).isEqualTo("testBranch1Data");
            Assertions.assertThat((String)dataOut.get("branch2data").textValue()).isEqualTo("testBranch2Data");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"serverless/prchecker.sw.json", "serverless/prchecker.sw.yml"})
    public void testPrCheckerWorkflow(String processLocation) throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        Application app = this.generateCodeProcessesOnly(processLocation);
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("prchecker");
        Model m = (Model)p.createModel();
        HashMap<String, JsonNode> parameters = new HashMap<String, JsonNode>();
        String jsonParamStr = "{}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonParamObj = mapper.readTree(jsonParamStr);
        parameters.put("workflowdata", jsonParamObj);
        m.fromMap(parameters);
        ProcessInstance processInstance = p.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        System.clearProperty("jbpm.enable.multi.con");
    }
}

