/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.Sig;

public class SubProcessIT
extends AbstractCodegenIT {
    @Test
    public void testSubProcess() throws Exception {
        Application app = this.generateCodeProcessesOnly("subprocess/SubProcess.bpmn", "subprocess/ParentProcess.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process parent = ((Processes)app.get(Processes.class)).processById("parent");
        Process subProcess = ((Processes)app.get(Processes.class)).processById("subprocess");
        Model m = (Model)parent.createModel();
        m.fromMap(Collections.singletonMap("name", "test"));
        ProcessInstance processInstance = parent.createInstance(m);
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Collection instances = subProcess.instances().values();
        Assertions.assertThat((Iterable)instances).hasSize(1);
        ProcessInstance subProcessInstance = (ProcessInstance)instances.iterator().next();
        ((MapAssert)Assertions.assertThat((Map)((Model)subProcessInstance.variables()).toMap()).hasSize(3)).contains(new Map.Entry[]{Assertions.entry((Object)"constant", (Object)"aString"), Assertions.entry((Object)"name", (Object)"test"), Assertions.entry((Object)"review", null)});
        subProcessInstance.send(Sig.of((String)"end", (Object)"another review"));
        Assertions.assertThat((int)subProcessInstance.status()).isEqualTo(2);
        ((MapAssert)Assertions.assertThat((Map)((Model)processInstance.variables()).toMap()).hasSize(2)).contains(new Map.Entry[]{Assertions.entry((Object)"name", (Object)"test"), Assertions.entry((Object)"review", (Object)"another review")});
        processInstance.send(Sig.of((String)"end", null));
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
    }
}

