/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.MilestoneNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.flexible.AdHocFragment;
import org.kie.kogito.process.impl.Sig;
import org.kie.kogito.process.workitem.Policy;

class AdHocFragmentsIT
extends AbstractCodegenIT {
    AdHocFragmentsIT() {
    }

    @Test
    void testAdHocFragments() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/AdHocFragments.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.AdHocFragments");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        Collection adHocFragments = processInstance.adHocFragments();
        ArrayList<AdHocFragment> expected = new ArrayList<AdHocFragment>();
        expected.add(new AdHocFragment.Builder(MilestoneNode.class).withName("AdHoc Milestone").withAutoStart(true).build());
        expected.add(new AdHocFragment.Builder(ActionNode.class).withName("AdHoc Script").withAutoStart(false).build());
        expected.add(new AdHocFragment.Builder(HumanTaskNode.class).withName("AdHoc User Task").withAutoStart(false).build());
        expected.add(new AdHocFragment.Builder(WorkItemNode.class).withName("Service Task").withAutoStart(false).build());
        AdHocFragmentsIT.assertAdHocFragments(expected, adHocFragments);
    }

    @Test
    void testStartUserTask() throws Exception {
        String taskName = "AdHoc User Task";
        Application app = this.generateCodeProcessesOnly("cases/AdHocFragments.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.AdHocFragments");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        Optional<WorkItem> workItem = processInstance.workItems(new Policy[0]).stream().filter(wi -> wi.getParameters().get("NodeName").equals(taskName)).findFirst();
        Assertions.assertThat(workItem).isNotPresent();
        processInstance.send(Sig.of((String)taskName, (Object)((Model)p.createModel())));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        workItem = processInstance.workItems(new Policy[0]).stream().filter(wi -> wi.getParameters().get("NodeName").equals(taskName)).findFirst();
        Assertions.assertThat(workItem).isPresent();
        Assertions.assertThat((String)workItem.get().getId()).isNotBlank();
        Assertions.assertThat((String)workItem.get().getName()).isNotBlank();
    }

    @Test
    void testStartFragments() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/AdHocFragments.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.AdHocFragments");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        processInstance.start();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", "Juan");
        processInstance.send(Sig.of((String)"Service Task", params));
        Model result = (Model)processInstance.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello Juan 5!", result.toMap().get("var1"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
    }

    @Test
    void testProcessAutoStart() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/AdHocProcess.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("AdHocProcess");
        Model model = (Model)p.createModel();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("var1", "Pablo");
        params.put("var2", "Luis");
        model.fromMap(params);
        ProcessInstance processInstance = p.createInstance(model);
        processInstance.start();
        Model result = (Model)processInstance.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello Pablo! Script", result.toMap().get("var1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Luis Script 2", result.toMap().get("var2"));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
    }

    private static void assertAdHocFragments(Collection<AdHocFragment> expected, Collection<AdHocFragment> current) {
        if (expected == null) {
            Assertions.assertThat(current).isNull();
        }
        Assertions.assertThat(current).isNotNull();
        Assertions.assertThat((int)current.size()).isEqualTo(expected.size());
        expected.forEach(e -> org.junit.jupiter.api.Assertions.assertTrue((boolean)current.stream().anyMatch(c -> c.getName().equals(e.getName()) && c.getType().equals(e.getType()) && c.isAutoStart() == e.isAutoStart()), (String)("Expected: " + e.toString() + ", Got: " + current.toString())));
    }
}

