/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.ruleflow.instance.RuleFlowProcessInstance;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.codegen.AbstractCodegenIT;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.flexible.ItemDescription;
import org.kie.kogito.process.flexible.Milestone;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.impl.ProcessTestUtils;
import org.kie.kogito.process.workitem.Policy;

class MilestoneIT
extends AbstractCodegenIT {
    MilestoneIT() {
    }

    @Test
    void testSimpleMilestone() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/milestones/SimpleMilestone.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.SimpleMilestone");
        ProcessInstance processInstance = p.createInstance((Model)p.createModel());
        ProcessTestUtils.assertState(processInstance, 0);
        Collection<Object> expected = new ArrayList<Milestone>();
        expected.add(Milestone.builder().withName("AutoStartMilestone").withStatus(ItemDescription.Status.AVAILABLE).build());
        expected.add(Milestone.builder().withName("SimpleMilestone").withStatus(ItemDescription.Status.AVAILABLE).build());
        this.assertMilestones(expected, processInstance.milestones());
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 2);
        expected = expected.stream().map(m -> Milestone.builder().withId(m.getId()).withName(m.getName()).withStatus(ItemDescription.Status.COMPLETED).build()).collect(Collectors.toList());
        this.assertMilestones(expected, processInstance.milestones());
        RuleFlowProcessInstance legacyProcessInstance = (RuleFlowProcessInstance)((AbstractProcessInstance)processInstance).processInstance;
        Assertions.assertThat((Iterable)legacyProcessInstance.getNodeInstances()).isEmpty();
        Assertions.assertThat((String)legacyProcessInstance.getNodeIdInError()).isNullOrEmpty();
        Optional<String> milestoneId = Stream.of(legacyProcessInstance.getNodeContainer().getNodes()).filter(node -> node.getName().equals("SimpleMilestone")).map(n -> (String)n.getMetaData().get("UniqueId")).findFirst();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)milestoneId.isPresent());
        Assertions.assertThat((List)legacyProcessInstance.getCompletedNodeIds()).contains((Object[])new String[]{milestoneId.get()});
    }

    @Test
    void testConditionalMilestone() throws Exception {
        Application app = this.generateCodeProcessesOnly("cases/milestones/ConditionalMilestone.bpmn");
        Assertions.assertThat((Object)app).isNotNull();
        Process p = ((Processes)app.get(Processes.class)).processById("TestCase.ConditionalMilestone");
        Model model = (Model)p.createModel();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("favouriteColour", "orange");
        model.fromMap(params);
        ProcessInstance processInstance = p.createInstance(model);
        ProcessTestUtils.assertState(processInstance, 0);
        Collection<Object> expected = new ArrayList<Milestone>();
        expected.add(Milestone.builder().withName("Milestone").withStatus(ItemDescription.Status.AVAILABLE).build());
        this.assertMilestones(expected, processInstance.milestones());
        processInstance.start();
        ProcessTestUtils.assertState(processInstance, 1);
        expected = expected.stream().map(m -> Milestone.builder().withId(m.getId()).withName(m.getName()).withStatus(ItemDescription.Status.AVAILABLE).build()).collect(Collectors.toList());
        this.assertMilestones(expected, processInstance.milestones());
        List workItems = processInstance.workItems(new Policy[0]);
        params.put("favouriteColour", "blue");
        processInstance.completeWorkItem(((WorkItem)workItems.get(0)).getId(), params, new Policy[0]);
        expected = expected.stream().map(m -> Milestone.builder().withId(m.getId()).withName(m.getName()).withStatus(ItemDescription.Status.COMPLETED).build()).collect(Collectors.toList());
        this.assertMilestones(expected, processInstance.milestones());
    }

    private void assertMilestones(Collection<Milestone> expected, Collection<Milestone> milestones) {
        if (expected == null) {
            org.junit.jupiter.api.Assertions.assertNull(milestones);
        }
        org.junit.jupiter.api.Assertions.assertNotNull(milestones);
        Assertions.assertThat(milestones).hasSameSizeAs(expected);
        expected.forEach(e -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)milestones.stream().anyMatch(c -> Objects.equals(c.getName(), e.getName()) && Objects.equals(c.getStatus(), e.getStatus()))).withFailMessage("Expected: " + e + " - Not present in: " + milestones, new Object[0])).isTrue());
    }
}

