/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.GeneratedFileType;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.prediction.PMMLResource;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.mockito.MockSettings;
import org.mockito.Mockito;

class PredictionCodegenTest {
    private static final Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).toAbsolutePath();
    private static final String REGRESSION_SOURCE = "prediction/test_regression.pmml";
    private static final Path REGRESSION_FULL_SOURCE = BASE_PATH.resolve("prediction/test_regression.pmml");
    private static final String SCORECARD_SOURCE = "prediction/test_scorecard.pmml";
    private static final Path SCORECARD_FULL_SOURCE = BASE_PATH.resolve("prediction/test_scorecard.pmml");
    private static final String MINING_SOURCE = "prediction/test_miningmodel.pmml";
    private static final Path MINING_FULL_SOURCE = BASE_PATH.resolve("prediction/test_miningmodel.pmml");
    private static final String MULTIPLE_SOURCE = "prediction/test_multiplemodels.pmml";
    private static final Path MULTIPLE_FULL_SOURCE = BASE_PATH.resolve("prediction/test_multiplemodels.pmml");
    private static final String REFLECT_JSON = "reflect-config.json";
    private static final String EMPTY = "";
    private static final String MOCK = "mock";
    private static final String NESTED_MOCK = "nestedMock";
    private static final String PMML = "PMML";

    PredictionCodegenTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        PredictionCodegen emptyCodeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        PredictionCodegen codeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{REGRESSION_FULL_SOURCE.toFile()}));
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(1);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateAllFilesRegression(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        PredictionCodegen codeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{REGRESSION_FULL_SOURCE.toFile()}));
        PredictionCodegenTest.generateAllFiles(context, codeGenerator, 5, 3, 1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateAllFilesScorecard(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        PredictionCodegen codeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{SCORECARD_FULL_SOURCE.toFile()}));
        PredictionCodegenTest.generateAllFiles(context, codeGenerator, 5, 3, 1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateAllFilesMining(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        PredictionCodegen codeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MINING_FULL_SOURCE.toFile()}));
        PredictionCodegenTest.generateAllFiles(context, codeGenerator, 14, 12, 1, false);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateAllFilesMultiple(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        PredictionCodegen codeGenerator = PredictionCodegen.ofCollectedResources((KogitoBuildContext)context, (Collection)CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{MULTIPLE_FULL_SOURCE.toFile()}));
        PredictionCodegenTest.generateAllFiles(context, codeGenerator, 9, 5, 2, false);
    }

    private static void generateAllFiles(KogitoBuildContext context, PredictionCodegen codeGenerator, int expectedTotalFiles, int expectedJavaSources, int expectedRestEndpoints, boolean assertReflect) {
        Collection generatedFiles = codeGenerator.generate();
        int expectedGeneratedFilesSize = expectedTotalFiles - (context.hasRESTForGenerator((Generator)codeGenerator) ? 0 : expectedRestEndpoints * 2);
        org.junit.jupiter.api.Assertions.assertEquals((int)expectedGeneratedFilesSize, (int)generatedFiles.size());
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedJavaSources, (long)generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.SOURCE) && generatedFile.type().name().equals(PMML) && generatedFile.relativePath().endsWith(".java")).count());
        int expectedReflectResource = assertReflect ? 1 : 0;
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedReflectResource, (long)generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.INTERNAL_RESOURCE) && generatedFile.type().name().equals(GeneratedFileType.INTERNAL_RESOURCE.name()) && generatedFile.relativePath().endsWith(REFLECT_JSON)).count());
        PredictionCodegenTest.assertEndpoints(context, generatedFiles, expectedRestEndpoints, codeGenerator);
        Optional optionalApplicationSection = codeGenerator.section();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)optionalApplicationSection.isPresent());
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)compilationUnit);
    }

    private static void assertEndpoints(KogitoBuildContext context, Collection<GeneratedFile> generatedFiles, int expectedRestEndpoints, PredictionCodegen codeGenerator) {
        if (context.hasRESTForGenerator((Generator)codeGenerator)) {
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedRestEndpoints, (long)generatedFiles.stream().filter(generatedFile -> generatedFile.type().equals(Generator.REST_TYPE)).count());
            org.junit.jupiter.api.Assertions.assertEquals((long)expectedRestEndpoints, (long)generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.STATIC_HTTP_RESOURCE) && generatedFile.type().name().equals(GeneratedFileType.STATIC_HTTP_RESOURCE.name()) && !generatedFile.relativePath().endsWith(REFLECT_JSON)).count());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithInvalidModel(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        KiePMMLModel nullNameMock = PredictionCodegenTest.buildInvalidMockedModel(null);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, nullNameMock));
        KiePMMLModel emptyNameMock = PredictionCodegenTest.buildInvalidMockedModel(EMPTY);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, emptyNameMock));
        KiePMMLModel invalidClassMock = PredictionCodegenTest.buildInvalidMockedModel(MOCK);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, invalidClassMock));
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithInvalidNestedModel(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        KiePMMLModel nullNameMock = PredictionCodegenTest.buildMockedModelWithInvalidNestedMockedModel(null);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, nullNameMock));
        KiePMMLModel emptyNameMock = PredictionCodegenTest.buildMockedModelWithInvalidNestedMockedModel(EMPTY);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, emptyNameMock));
        KiePMMLModel invalidClassMock = PredictionCodegenTest.buildMockedModelWithInvalidNestedMockedModel(NESTED_MOCK);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, (Executable)PredictionCodegenTest.buildMockedGenerateExecutable(context, invalidClassMock));
    }

    private static KiePMMLModel buildInvalidMockedModel(String name) {
        KiePMMLModel mock = (KiePMMLModel)Mockito.mock(KiePMMLModel.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }

    private static KiePMMLModel buildMockedModelWithInvalidNestedMockedModel(String name) {
        KiePMMLModel mock = (KiePMMLModel)Mockito.mock(KiePMMLModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasSourcesMap.class, HasNestedModels.class}));
        Mockito.when((Object)mock.getName()).thenReturn((Object)MOCK);
        HasSourcesMap smMock = (HasSourcesMap)mock;
        Mockito.when((Object)smMock.getSourcesMap()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)smMock.getRulesSourcesMap()).thenReturn(null);
        List<KiePMMLModel> nestedModelsMock = Collections.singletonList(PredictionCodegenTest.buildInvalidMockedModel(name));
        HasNestedModels nmMock = (HasNestedModels)mock;
        Mockito.when((Object)nmMock.getNestedModels()).thenReturn(nestedModelsMock);
        return mock;
    }

    private static PMMLResource buildMockedResource(KiePMMLModel mockedModel) {
        PMMLResource mock = (PMMLResource)Mockito.mock(PMMLResource.class);
        Mockito.when((Object)mock.getModelPath()).thenReturn((Object)EMPTY);
        Mockito.when((Object)mock.getKiePmmlModels()).thenReturn(Collections.singletonList(mockedModel));
        return mock;
    }

    private static Executable buildMockedGenerateExecutable(KogitoBuildContext context, KiePMMLModel mockedModel) {
        return () -> {
            List<PMMLResource> mockedResourceList = Collections.singletonList(PredictionCodegenTest.buildMockedResource(mockedModel));
            PredictionCodegen codeGenerator = new PredictionCodegen(context, mockedResourceList);
            codeGenerator.generate();
        };
    }
}

