/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.drools.codegen.common.GeneratedFile;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.prediction.PredictionCodegenGenerateTest;

class PredictionCodegenInternalGenerateTest {
    PredictionCodegenInternalGenerateTest() {
    }

    @BeforeAll
    public static void setup() {
        System.setProperty("indexfile.directory", "target/test-classes");
    }

    @AfterAll
    public static void cleanup() {
        System.clearProperty("indexfile.directory");
    }

    private static Stream<Arguments> data() {
        return KogitoContextTestUtils.contextBuilders().flatMap(arguments -> {
            KogitoBuildContext.Builder contextBuilder = (KogitoBuildContext.Builder)Arrays.stream(arguments.get()).findFirst().orElseThrow(() -> new IllegalStateException("Failed to retrieve KogitoBuildContext.Builder"));
            KogitoBuildContext context = contextBuilder.build();
            ArrayList<Arguments> testArguments = new ArrayList<Arguments>();
            PredictionCodegen codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, PredictionCodegenGenerateTest.REGRESSION_FULL_SOURCE);
            Collection generatedFiles = codeGenerator.internalGenerate();
            Arguments toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 4, 3, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, PredictionCodegenGenerateTest.SCORECARD_FULL_SOURCE);
            generatedFiles = codeGenerator.internalGenerate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 36, 34, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, PredictionCodegenGenerateTest.MINING_FULL_SOURCE);
            generatedFiles = codeGenerator.internalGenerate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 79, 77, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, PredictionCodegenGenerateTest.MULTIPLE_FULL_SOURCE);
            generatedFiles = codeGenerator.internalGenerate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 86, 84, 2, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            return testArguments.stream();
        });
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyTotalFiles(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyTotalFiles(generatedFiles, expectedTotalFiles, expectedRestEndpoints, hasRest);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyCompiledClasses(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyCompiledClasses(generatedFiles, expectedCompiledClasses);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyReflectResource(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyReflectResource(generatedFiles, assertReflect);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyRestEndpoints(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyRestEndpoints(generatedFiles, expectedRestEndpoints, hasRest);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifySectionAndCompilationUnit(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifySectionAndCompilationUnit(codeGenerator);
    }
}

