/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.prediction.PMMLResource;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.pmml.commons.model.HasNestedModels;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.mockito.MockSettings;
import org.mockito.Mockito;

class PredictionCodegenFactoryTest {
    static final String REFLECT_JSON = "reflect-config.json";
    private static final String EMPTY = "";
    private static final String MOCK = "mock";
    private static final String NESTED_MOCK = "nestedMock";

    PredictionCodegenFactoryTest() {
    }

    @BeforeAll
    public static void setup() {
        System.setProperty("indexfile.directory", "target/test-classes");
    }

    @AfterAll
    public static void cleanup() {
        System.clearProperty("indexfile.directory");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithNullNameInvalidModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel nullNameMock = PredictionCodegenFactoryTest.buildInvalidMockedModel(null);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, nullNameMock);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithEmptyNameInvalidModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel emptyNameMock = PredictionCodegenFactoryTest.buildInvalidMockedModel(EMPTY);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, emptyNameMock);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithInvalidClassInvalidModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel invalidClassMock = PredictionCodegenFactoryTest.buildInvalidMockedModel(MOCK);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, invalidClassMock);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithNullNameNestedModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel nullNameMock = PredictionCodegenFactoryTest.buildMockedModelWithInvalidNestedMockedModel(null);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, nullNameMock);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithEmptyNameNestedModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel emptyNameMock = PredictionCodegenFactoryTest.buildMockedModelWithInvalidNestedMockedModel(EMPTY);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, emptyNameMock);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateThrowsExceptionWithInvalidClassNestedModel(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel invalidClassMock = PredictionCodegenFactoryTest.buildMockedModelWithInvalidNestedMockedModel(NESTED_MOCK);
        this.commonVerifyExceptionThrownByBuildMockedGenerateExecutable(contextBuilder, invalidClassMock);
    }

    private static KiePMMLModel buildInvalidMockedModel(String name) {
        KiePMMLModel mock = (KiePMMLModel)Mockito.mock(KiePMMLModel.class);
        Mockito.when((Object)mock.getName()).thenReturn((Object)name);
        return mock;
    }

    private static KiePMMLModel buildMockedModelWithInvalidNestedMockedModel(String name) {
        KiePMMLModel mock = (KiePMMLModel)Mockito.mock(KiePMMLModel.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{HasSourcesMap.class, HasNestedModels.class}));
        Mockito.when((Object)mock.getName()).thenReturn((Object)MOCK);
        HasSourcesMap smMock = (HasSourcesMap)mock;
        Mockito.when((Object)smMock.getSourcesMap()).thenReturn(Collections.emptyMap());
        List<KiePMMLModel> nestedModelsMock = Collections.singletonList(PredictionCodegenFactoryTest.buildInvalidMockedModel(name));
        HasNestedModels nmMock = (HasNestedModels)mock;
        Mockito.when((Object)nmMock.getNestedModels()).thenReturn(nestedModelsMock);
        return mock;
    }

    private static PMMLResource buildMockedResource(KiePMMLModel mockedModel) {
        PMMLResource mock = (PMMLResource)Mockito.mock(PMMLResource.class);
        Mockito.when((Object)mock.getModelPath()).thenReturn((Object)EMPTY);
        Mockito.when((Object)mock.getKiePmmlModels()).thenReturn(Collections.singletonList(mockedModel));
        return mock;
    }

    private static void buildMockedGenerateExecutable(KogitoBuildContext context, KiePMMLModel mockedModel) {
        List<PMMLResource> mockedResourceList = Collections.singletonList(PredictionCodegenFactoryTest.buildMockedResource(mockedModel));
        PredictionCodegen codeGenerator = new PredictionCodegen(context, mockedResourceList);
        codeGenerator.generate();
    }

    private void commonVerifyExceptionThrownByBuildMockedGenerateExecutable(KogitoBuildContext.Builder contextBuilder, KiePMMLModel pmmlModel) {
        KogitoBuildContext context = contextBuilder.build();
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> PredictionCodegenFactoryTest.buildMockedGenerateExecutable(context, pmmlModel));
    }
}

