/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.model.codegen.execmodel.GeneratedFile;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.prediction.PMMLResource;
import org.kie.kogito.codegen.prediction.PredictionCodegenUtils;
import org.kie.kogito.pmml.CommonTestUtility;
import org.kie.pmml.api.models.MiningField;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.model.KiePMMLModelWithSources;

class PredictionCodegenUtilsTest {
    private static KiePMMLModel kiePMMLModel;

    PredictionCodegenUtilsTest() {
    }

    @BeforeAll
    public static void setup() {
        List miningFields = CommonTestUtility.getRandomMiningFields();
        List outputFields = CommonTestUtility.getRandomOutputFields();
        outputFields.add(CommonTestUtility.getRandomOutputField((String)((MiningField)miningFields.get(miningFields.size() - 1)).getName()));
        kiePMMLModel = CommonTestUtility.getKiePMMLModelInternal((List)miningFields, (List)outputFields);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void checkModelHasSourcesMap(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModelWithSources hasSourcesMap = new KiePMMLModelWithSources("fileName", "modelName", "kmodulePackageName", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap(), true);
        this.commonVerifyExceptionThrownCheckModel((KiePMMLModel)hasSourcesMap, "Unexpected HasSourcesMap instance");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void checkModelNoModelName(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel noModelName = CommonTestUtility.getKiePMMLModelInternal((String)"fileName", null, Collections.emptyList(), Collections.emptyList());
        this.commonVerifyExceptionThrownCheckModel(noModelName, "Model name should not be empty");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void checkModelEmptyModelName(KogitoBuildContext.Builder contextBuilder) {
        KiePMMLModel emptyModelName = CommonTestUtility.getKiePMMLModelInternal((String)"fileName", (String)"", Collections.emptyList(), Collections.emptyList());
        this.commonVerifyExceptionThrownCheckModel(emptyModelName, "Model name should not be empty");
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateModelBaseFiles(KogitoBuildContext.Builder contextBuilder) {
        ArrayList files = new ArrayList();
        String modelPath = "/model/path/PmmlModel.pmml";
        HashMap compiledClasses = new HashMap();
        IntStream.range(0, 3).forEach(i -> compiledClasses.put("generated.package.Class" + i, new byte[0]));
        PMMLResource resource = new PMMLResource(Collections.singletonList(kiePMMLModel), Path.of(modelPath, new String[0]), modelPath, compiledClasses, Collections.emptyMap());
        PredictionCodegenUtils.generateModelBaseFiles(files, (PMMLResource)resource);
        Assertions.assertThat(files).hasSize(compiledClasses.size());
        compiledClasses.keySet().forEach(fullClassName -> {
            Assertions.assertThat((Collection)files).extracting(file -> file.path().toString()).contains((Object[])new String[]{fullClassName});
            Optional<GeneratedFile> generatedFile = files.stream().filter(file -> file.path().toString().equals(fullClassName)).findFirst();
            Assertions.assertThat(generatedFile).isPresent();
            Assertions.assertThat((String)generatedFile.get().type().name()).isEqualTo(GeneratedFileType.COMPILED_CLASS.name());
            Assertions.assertThat((Comparable)generatedFile.get().type().category()).isEqualTo((Object)GeneratedFileType.Category.COMPILED_CLASS);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generateModelRESTFiles(KogitoBuildContext.Builder contextBuilder) {
        ArrayList files = new ArrayList();
        PredictionCodegenUtils.generateModelRESTFiles(files, (KiePMMLModel)kiePMMLModel, (KogitoBuildContext)contextBuilder.build(), (String)"ApplicationCanonicalName");
        Assertions.assertThat(files).hasSize(2);
        Assertions.assertThat(files).extracting(file -> file.type().name()).contains((Object[])new String[]{GeneratedFileType.STATIC_HTTP_RESOURCE.name(), GeneratedFile.Type.REST.name()});
    }

    private void commonVerifyExceptionThrownCheckModel(KiePMMLModel pmmlModel, String message) {
        Assertions.assertThatExceptionOfType(IllegalStateException.class).isThrownBy(() -> PredictionCodegenUtils.checkModel((KiePMMLModel)pmmlModel)).withMessageContaining(message);
    }
}

