/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import com.github.javaparser.ast.CompilationUnit;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.api.io.ResourceType;
import org.kie.kogito.codegen.api.ApplicationSection;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.utils.KogitoContextTestUtils;
import org.kie.kogito.codegen.core.io.CollectedResourceProducer;
import org.kie.kogito.codegen.prediction.PredictionCodegen;
import org.kie.kogito.codegen.prediction.PredictionCodegenFactory;

class PredictionCodegenGenerateTest {
    static final Path BASE_PATH = Paths.get("src/test/resources/", new String[0]).toAbsolutePath();
    private static final String REGRESSION_SOURCE = "prediction/test_regression.pmml";
    static final Path REGRESSION_FULL_SOURCE = BASE_PATH.resolve("prediction/test_regression.pmml");
    private static final String SCORECARD_SOURCE = "prediction/test_scorecard.pmml";
    static final Path SCORECARD_FULL_SOURCE = BASE_PATH.resolve("prediction/test_scorecard.pmml");
    private static final String MINING_SOURCE = "prediction/test_miningmodel.pmml";
    static final Path MINING_FULL_SOURCE = BASE_PATH.resolve("prediction/test_miningmodel.pmml");
    static final String MULTIPLE_SOURCE = "prediction/test_multiplemodels.pmml";
    static final Path MULTIPLE_FULL_SOURCE = BASE_PATH.resolve("prediction/test_multiplemodels.pmml");

    PredictionCodegenGenerateTest() {
    }

    @BeforeAll
    public static void setup() {
        System.setProperty("indexfile.directory", "target/test-classes");
    }

    @AfterAll
    public static void cleanup() {
        System.clearProperty("indexfile.directory");
    }

    private static Stream<Arguments> data() {
        return KogitoContextTestUtils.contextBuilders().flatMap(arguments -> {
            KogitoBuildContext.Builder contextBuilder = (KogitoBuildContext.Builder)Arrays.stream(arguments.get()).findFirst().orElseThrow(() -> new IllegalStateException("Failed to retrieve KogitoBuildContext.Builder"));
            KogitoBuildContext context = contextBuilder.build();
            ArrayList<Arguments> testArguments = new ArrayList<Arguments>();
            PredictionCodegen codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, REGRESSION_FULL_SOURCE);
            Collection generatedFiles = codeGenerator.generate();
            Arguments toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 4, 3, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, SCORECARD_FULL_SOURCE);
            generatedFiles = codeGenerator.generate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 36, 34, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, MINING_FULL_SOURCE);
            generatedFiles = codeGenerator.generate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 79, 77, 1, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            codeGenerator = PredictionCodegenGenerateTest.getPredictionCodegen(context, MULTIPLE_FULL_SOURCE);
            generatedFiles = codeGenerator.generate();
            toAdd = Arguments.arguments((Object[])new Object[]{codeGenerator, generatedFiles, 86, 84, 2, false, context.hasRESTForGenerator((Generator)codeGenerator)});
            testArguments.add(toAdd);
            return testArguments.stream();
        });
    }

    static PredictionCodegen getPredictionCodegen(KogitoBuildContext context, Path modelPath) {
        Collection resources = CollectedResourceProducer.fromFiles((Path)BASE_PATH, (File[])new File[]{modelPath.toFile()});
        Collection pmmlResources = resources.stream().filter(r -> r.resource().getResourceType() == ResourceType.PMML).flatMap(r -> PredictionCodegenFactory.parsePredictions((ClassLoader)Thread.currentThread().getContextClassLoader(), (Path)r.basePath(), Collections.singletonList(r.resource())).stream()).collect(Collectors.toList());
        return new PredictionCodegen(context, pmmlResources);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyTotalFiles(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyTotalFiles(generatedFiles, expectedTotalFiles, expectedRestEndpoints, hasRest);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyCompiledClasses(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyCompiledClasses(generatedFiles, expectedCompiledClasses);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyReflectResource(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyReflectResource(generatedFiles, assertReflect);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifyRestEndpoints(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifyRestEndpoints(generatedFiles, expectedRestEndpoints, hasRest);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void verifySectionAndCompilationUnit(PredictionCodegen codeGenerator, Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedCompiledClasses, int expectedRestEndpoints, boolean assertReflect, boolean hasRest) {
        PredictionCodegenGenerateTest.commonVerifySectionAndCompilationUnit(codeGenerator);
    }

    static void commonVerifyTotalFiles(Collection<GeneratedFile> generatedFiles, int expectedTotalFiles, int expectedRestEndpoints, boolean hasREST) {
        int expectedGeneratedFilesSize = expectedTotalFiles + (hasREST ? expectedRestEndpoints * 2 : 0);
        Assertions.assertThat(generatedFiles).hasSize(expectedGeneratedFilesSize);
    }

    static void commonVerifyCompiledClasses(Collection<GeneratedFile> generatedFiles, int expectedCompiledClasses) {
        Assertions.assertThat((int)expectedCompiledClasses).isEqualTo(generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.COMPILED_CLASS) && generatedFile.type().equals(GeneratedFileType.COMPILED_CLASS)).count());
    }

    static void commonVerifyReflectResource(Collection<GeneratedFile> generatedFiles, boolean assertReflect) {
        int expectedReflectResource = assertReflect ? 1 : 0;
        Assertions.assertThat((int)expectedReflectResource).isEqualTo(generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.INTERNAL_RESOURCE) && generatedFile.type().name().equals(GeneratedFileType.INTERNAL_RESOURCE.name()) && generatedFile.relativePath().endsWith("reflect-config.json")).count());
    }

    static void commonVerifyRestEndpoints(Collection<GeneratedFile> generatedFiles, int expectedRestEndpoints, boolean hasREST) {
        if (hasREST) {
            Assertions.assertThat((int)expectedRestEndpoints).isEqualTo(generatedFiles.stream().filter(generatedFile -> generatedFile.type().equals(Generator.REST_TYPE)).count());
            Assertions.assertThat((int)expectedRestEndpoints).isEqualTo(generatedFiles.stream().filter(generatedFile -> generatedFile.category().equals((Object)GeneratedFileType.Category.STATIC_HTTP_RESOURCE) && generatedFile.type().name().equals(GeneratedFileType.STATIC_HTTP_RESOURCE.name()) && !generatedFile.relativePath().endsWith("reflect-config.json")).count());
        }
    }

    static void commonVerifySectionAndCompilationUnit(PredictionCodegen codeGenerator) {
        Optional optionalApplicationSection = codeGenerator.section();
        Assertions.assertThat((Optional)optionalApplicationSection).isPresent();
        CompilationUnit compilationUnit = ((ApplicationSection)optionalApplicationSection.get()).compilationUnit();
        Assertions.assertThat((Object)compilationUnit).isNotNull();
    }
}

