/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction.config;

import org.drools.codegen.common.GeneratedFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.prediction.config.PredictionConfigGenerator;

class PredictionConfigGeneratorTest {
    private static final String PACKAGE_NAME = "PACKAGENAME";

    PredictionConfigGeneratorTest() {
    }

    @Test
    void compilationUnitWithCDI() {
        KogitoBuildContext context = QuarkusKogitoBuildContext.builder().withPackageName(PACKAGE_NAME).build();
        PredictionConfigGenerator predictionConfigGenerator = new PredictionConfigGenerator(context);
        GeneratedFile retrieved = predictionConfigGenerator.generate();
        Assertions.assertNotNull((Object)retrieved);
        String retrievedContent = new String(retrieved.contents());
        String expected = "@javax.inject.Singleton";
        Assertions.assertTrue((boolean)retrievedContent.contains(expected));
        expected = "@javax.inject.Inject";
        Assertions.assertTrue((boolean)retrievedContent.contains(expected));
        String unexpected = "@org.springframework.stereotype.Component";
        Assertions.assertFalse((boolean)retrievedContent.contains(unexpected));
        unexpected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertFalse((boolean)retrievedContent.contains(unexpected));
    }

    @Test
    void compilationUnitWithSpring() {
        KogitoBuildContext context = SpringBootKogitoBuildContext.builder().withPackageName(PACKAGE_NAME).build();
        PredictionConfigGenerator predictionConfigGenerator = new PredictionConfigGenerator(context);
        GeneratedFile retrieved = predictionConfigGenerator.generate();
        Assertions.assertNotNull((Object)retrieved);
        String retrievedContent = new String(retrieved.contents());
        String expected = "@org.springframework.stereotype.Component";
        Assertions.assertTrue((boolean)retrievedContent.contains(expected));
        expected = "@org.springframework.beans.factory.annotation.Autowired";
        Assertions.assertTrue((boolean)retrievedContent.contains(expected));
        String unexpected = "@javax.inject.Singleton";
        Assertions.assertFalse((boolean)retrievedContent.contains(unexpected));
        unexpected = "@javax.inject.Inject";
        Assertions.assertFalse((boolean)retrievedContent.contains(unexpected));
    }
}

