/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.prediction;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.drools.core.util.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.dmn.feel.codegen.feel11.CodegenStringUtil;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.QuarkusKogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.SpringBootKogitoBuildContext;
import org.kie.kogito.codegen.api.di.DependencyInjectionAnnotator;
import org.kie.kogito.codegen.api.di.impl.CDIDependencyInjectionAnnotator;
import org.kie.kogito.codegen.api.template.TemplatedGenerator;
import org.kie.kogito.codegen.prediction.PMMLRestResourceGenerator;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;

class PMMLRestResourceGeneratorTest {
    private static final String APP_CANONICAL_NAME = "APP_CANONICAL_NAME";
    private static final KiePMMLModel KIE_PMML_MODEL = PMMLRestResourceGeneratorTest.getKiePMMLModelInternal();
    private static final String INPUT_REF = "inputRef";
    private static final String RESULT_REF = "resultRef";
    private static final String OUTPUT_REF = "outputRef";
    private static final ClassOrInterfaceDeclaration TEMPLATE = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration(QuarkusKogitoBuildContext.builder().build());
    private static PMMLRestResourceGenerator pmmlRestResourceGenerator;
    private static KogitoBuildContext context;

    PMMLRestResourceGeneratorTest() {
    }

    @BeforeAll
    public static void setup() {
        context = QuarkusKogitoBuildContext.builder().build();
        pmmlRestResourceGenerator = new PMMLRestResourceGenerator(context, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        Assertions.assertNotNull((Object)pmmlRestResourceGenerator);
    }

    private static KiePMMLModel getKiePMMLModelInternal() {
        String modelName = "MODEL_NAME";
        return new KiePMMLModel(modelName, Collections.emptyList()){

            public Object evaluate(Object o, Map<String, Object> map) {
                return null;
            }
        };
    }

    private static ClassOrInterfaceDeclaration getClassOrInterfaceDeclaration(KogitoBuildContext context) {
        CompilationUnit clazz = TemplatedGenerator.builder().build(context, "PMMLRestResource").compilationUnitOrThrow();
        clazz.setPackageDeclaration(CodegenStringUtil.escapeIdentifier((String)"IDENTIFIER"));
        return (ClassOrInterfaceDeclaration)clazz.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
    }

    @Test
    void constructor() {
        Assertions.assertTrue((boolean)PMMLRestResourceGeneratorTest.pmmlRestResourceGenerator.restPackageName.startsWith("org.kie.kogito"));
        Assertions.assertEquals((Object)APP_CANONICAL_NAME, (Object)PMMLRestResourceGeneratorTest.pmmlRestResourceGenerator.appCanonicalName);
    }

    @Test
    void generateWithDependencyInjection() {
        context.setDependencyInjectionAnnotator((DependencyInjectionAnnotator)new CDIDependencyInjectionAnnotator());
        String retrieved = pmmlRestResourceGenerator.generate();
        this.commonEvaluateGenerate(retrieved);
        String expected = "Application application;";
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void generateWithoutDependencyInjection() {
        context.setDependencyInjectionAnnotator(null);
        String retrieved = pmmlRestResourceGenerator.generate();
        this.commonEvaluateGenerate(retrieved);
        String expected = String.format("Application application = new %s();", APP_CANONICAL_NAME);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void getNameURL() {
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = URLEncoder.encode(classPrefix).replaceAll("\\+", " ");
        Assertions.assertEquals((Object)expected, (Object)pmmlRestResourceGenerator.getNameURL());
    }

    @Test
    void getKiePMMLModel() {
        Assertions.assertEquals((Object)KIE_PMML_MODEL, (Object)pmmlRestResourceGenerator.getKiePMMLModel());
    }

    @Test
    void className() {
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = StringUtils.ucFirst((String)classPrefix) + "Resource";
        Assertions.assertEquals((Object)expected, (Object)pmmlRestResourceGenerator.className());
    }

    @Test
    void generatedFilePath() {
        String retrieved = pmmlRestResourceGenerator.generatedFilePath();
        Assertions.assertTrue((boolean)retrieved.startsWith("org/kie/kogito"));
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = StringUtils.ucFirst((String)classPrefix) + "Resource.java";
        Assertions.assertTrue((boolean)retrieved.endsWith(expected));
    }

    @Test
    void setPathValue() {
        Optional retrievedOpt = TEMPLATE.findFirst(SingleMemberAnnotationExpr.class);
        Assertions.assertTrue((boolean)retrievedOpt.isPresent());
        SingleMemberAnnotationExpr retrieved = (SingleMemberAnnotationExpr)retrievedOpt.get();
        Assertions.assertEquals((Object)"Path", (Object)retrieved.getName().asString());
        pmmlRestResourceGenerator.setPathValue(TEMPLATE);
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = URLEncoder.encode(classPrefix).replaceAll("\\+", " ");
        Assertions.assertEquals((Object)expected, (Object)retrieved.getMemberValue().asStringLiteralExpr().asString());
    }

    @Test
    void setPredictionModelName() {
        Assertions.assertTrue((boolean)TEMPLATE.getFieldByName("MODEL_NAME").isPresent());
        FieldDeclaration modelName = (FieldDeclaration)TEMPLATE.getFieldByName("MODEL_NAME").get();
        Assertions.assertFalse((boolean)modelName.getVariable(0).getInitializer().isPresent());
        pmmlRestResourceGenerator.setPredictionModelName(TEMPLATE);
        Assertions.assertTrue((boolean)modelName.getVariable(0).getInitializer().isPresent());
        Assertions.assertEquals((Object)KIE_PMML_MODEL.getName(), (Object)((Expression)modelName.getVariable(0).getInitializer().get()).asStringLiteralExpr().asString());
    }

    @Test
    void setQuarkusResultAOSAnnotations() {
        ClassOrInterfaceDeclaration quarkusTemplate = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration(QuarkusKogitoBuildContext.builder().build());
        KogitoBuildContext quarkusContext = QuarkusKogitoBuildContext.builder().build();
        PMMLRestResourceGenerator quarkusPMMLRestResourceGenerator = new PMMLRestResourceGenerator(quarkusContext, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        NodeList annotations = ((MethodDeclaration)quarkusTemplate.getMethodsByName("result").get(0)).getAnnotations();
        quarkusPMMLRestResourceGenerator.setQuarkusOASAnnotations(annotations, INPUT_REF, RESULT_REF);
        String retrieved = quarkusTemplate.toString();
        String expected = String.format("@%1$s(%2$s = @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML input\")", "org.eclipse.microprofile.openapi.annotations.parameters.RequestBody", "content", "schema", "org.eclipse.microprofile.openapi.annotations.media.Schema", "ref", INPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("@%1$s(%2$s = @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML result\")", "org.eclipse.microprofile.openapi.annotations.responses.APIResponse", "content", "schema", "org.eclipse.microprofile.openapi.annotations.media.Schema", "ref", RESULT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void setQuarkusDescriptiveOASAnnotations() {
        ClassOrInterfaceDeclaration quarkusTemplate = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration(QuarkusKogitoBuildContext.builder().build());
        KogitoBuildContext quarkusContext = QuarkusKogitoBuildContext.builder().build();
        PMMLRestResourceGenerator quarkusPMMLRestResourceGenerator = new PMMLRestResourceGenerator(quarkusContext, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        NodeList annotations = ((MethodDeclaration)quarkusTemplate.getMethodsByName("descriptive").get(0)).getAnnotations();
        quarkusPMMLRestResourceGenerator.setQuarkusOASAnnotations(annotations, INPUT_REF, OUTPUT_REF);
        String retrieved = quarkusTemplate.toString();
        String expected = String.format("@%1$s(%2$s = @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML input\")", "org.eclipse.microprofile.openapi.annotations.parameters.RequestBody", "content", "schema", "org.eclipse.microprofile.openapi.annotations.media.Schema", "ref", INPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("@%1$s(%2$s = @org.eclipse.microprofile.openapi.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML full output\")", "org.eclipse.microprofile.openapi.annotations.responses.APIResponse", "content", "schema", "org.eclipse.microprofile.openapi.annotations.media.Schema", "ref", OUTPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void setSpringResultOASAnnotations() {
        ClassOrInterfaceDeclaration springTemplate = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration(SpringBootKogitoBuildContext.builder().build());
        KogitoBuildContext springContext = SpringBootKogitoBuildContext.builder().build();
        PMMLRestResourceGenerator springPMMLRestResourceGenerator = new PMMLRestResourceGenerator(springContext, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        NodeList annotations = ((MethodDeclaration)springTemplate.getMethodsByName("result").get(0)).getAnnotations();
        springPMMLRestResourceGenerator.setSpringOASAnnotations(annotations, INPUT_REF, RESULT_REF);
        String retrieved = springTemplate.toString();
        String expected = String.format("@%1$s(%2$s = @io.swagger.v3.oas.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML input\")", "io.swagger.v3.oas.annotations.parameters.RequestBody", "content", "schema", "io.swagger.v3.oas.annotations.media.Schema", "ref", INPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("@%1$s(%2$s = @io.swagger.v3.oas.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML result\")", "io.swagger.v3.oas.annotations.responses.ApiResponse", "content", "schema", "io.swagger.v3.oas.annotations.media.Schema", "ref", RESULT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    @Test
    void setSpringDescriptiveOASAnnotations() {
        ClassOrInterfaceDeclaration springTemplate = PMMLRestResourceGeneratorTest.getClassOrInterfaceDeclaration(SpringBootKogitoBuildContext.builder().build());
        KogitoBuildContext springContext = SpringBootKogitoBuildContext.builder().build();
        PMMLRestResourceGenerator springPMMLRestResourceGenerator = new PMMLRestResourceGenerator(springContext, KIE_PMML_MODEL, APP_CANONICAL_NAME);
        NodeList annotations = ((MethodDeclaration)springTemplate.getMethodsByName("descriptive").get(0)).getAnnotations();
        springPMMLRestResourceGenerator.setSpringOASAnnotations(annotations, INPUT_REF, OUTPUT_REF);
        String retrieved = springTemplate.toString();
        String expected = String.format("@%1$s(%2$s = @io.swagger.v3.oas.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML input\")", "io.swagger.v3.oas.annotations.parameters.RequestBody", "content", "schema", "io.swagger.v3.oas.annotations.media.Schema", "ref", INPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = String.format("@%1$s(%2$s = @io.swagger.v3.oas.annotations.media.Content(mediaType = \"application/json\", %3$s = @%4$s(%5$s = \"%6$s\")), description = \"PMML full output\")", "io.swagger.v3.oas.annotations.responses.ApiResponse", "content", "schema", "io.swagger.v3.oas.annotations.media.Schema", "ref", OUTPUT_REF);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }

    private void commonEvaluateGenerate(String retrieved) {
        Assertions.assertNotNull((Object)retrieved);
        String classPrefix = KiePMMLModelUtils.getSanitizedClassName((String)KIE_PMML_MODEL.getName());
        String expected = String.format("@Path(\"%s\")", classPrefix);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
        expected = StringUtils.ucFirst((String)classPrefix) + "Resource";
        expected = String.format("public class %s extends org.kie.kogito.pmml.AbstractPMMLRestResource {", expected);
        Assertions.assertTrue((boolean)retrieved.contains(expected));
    }
}

