/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.data.GeneratedPOJO;
import org.kie.kogito.codegen.process.persistence.AbstractPersistenceGeneratorTest;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ProtoGenerator;
import org.kie.kogito.codegen.process.persistence.proto.ReflectionProtoGenerator;

class FileSystemPersistenceGeneratorTest
extends AbstractPersistenceGeneratorTest {
    FileSystemPersistenceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"persistenceTestContexts"})
    void test(KogitoBuildContext context) {
        context.setApplicationProperty("kogito.persistence.type", (Object)this.persistenceType());
        ReflectionProtoGenerator protoGenerator = (ReflectionProtoGenerator)ReflectionProtoGenerator.builder().build(Collections.singleton(GeneratedPOJO.class));
        PersistenceGenerator persistenceGenerator = new PersistenceGenerator(context, (ProtoGenerator)protoGenerator);
        Collection generatedFiles = persistenceGenerator.generate();
        int factoryFiles = context.hasRESTForGenerator((Generator)persistenceGenerator) ? 1 : 0;
        int marshallerFiles = PersistenceGenerator.hasProtoMarshaller((KogitoBuildContext)context) ? 14 : 0;
        int dataIndexFiles = PersistenceGenerator.hasDataIndexProto((KogitoBuildContext)context) ? 2 : 0;
        int expectedNumberOfFiles = factoryFiles + marshallerFiles + dataIndexFiles;
        Assertions.assertThat((Collection)generatedFiles).hasSize(expectedNumberOfFiles);
        if (context.hasDI()) {
            Optional<GeneratedFile> persistenceFactoryImpl = generatedFiles.stream().filter(gf -> gf.relativePath().equals("org/kie/kogito/persistence/KogitoProcessInstancesFactoryImpl.java")).findFirst();
            Assertions.assertThat(persistenceFactoryImpl).isNotEmpty();
            CompilationUnit compilationUnit = StaticJavaParser.parse((InputStream)new ByteArrayInputStream(persistenceFactoryImpl.get().contents()));
            ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)compilationUnit.findFirst(ClassOrInterfaceDeclaration.class).orElseThrow(() -> new NoSuchElementException("Compilation unit doesn't contain a class or interface declaration!"));
            Optional methodDeclaration = classDeclaration.findFirst(MethodDeclaration.class, d -> d.getName().getIdentifier().equals("path"));
            Assertions.assertThat((Optional)methodDeclaration).isNotEmpty();
            Optional fieldDeclaration = classDeclaration.findFirst(FieldDeclaration.class);
            Assertions.assertThat((Optional)fieldDeclaration).isNotEmpty();
            Assertions.assertThat((List)((FieldDeclaration)fieldDeclaration.get()).getVariables()).hasSize(1);
            Assertions.assertThat((String)((VariableDeclarator)((FieldDeclaration)fieldDeclaration.get()).getVariables().get(0)).getName().asString()).isEqualTo("path");
        }
    }

    @Override
    protected String persistenceType() {
        return "filesystem";
    }
}

