/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.process.persistence;

import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.AddonsConfig;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.process.persistence.PersistenceGenerator;

class PersistenceGeneratorTest {
    PersistenceGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext noPersistenceContext = contextBuilder.withAddonsConfig(AddonsConfig.builder().withPersistence(false).build()).build();
        PersistenceGenerator emptyCodeGenerator = new PersistenceGenerator(noPersistenceContext, null);
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        KogitoBuildContext persistenceContext = contextBuilder.withAddonsConfig(AddonsConfig.builder().withPersistence(true).build()).build();
        PersistenceGenerator codeGenerator = new PersistenceGenerator(persistenceContext, null);
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
    }
}

