/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.codegen.data.Person;
import org.kie.kogito.codegen.json.KogitoModule;
import org.kie.kogito.rules.DataHandle;
import org.kie.kogito.rules.DataProcessor;
import org.kie.kogito.rules.DataStore;
import org.kie.kogito.rules.SingletonStore;

public class KogitoJsonMapperTest {
    @Test
    public void testDataStore() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KogitoModule());
        List<Person> input = Arrays.asList(new Person("Mario", 46), new Person("Sofia", 8));
        Object text = objectMapper.writeValueAsString(input);
        text = "{\"store\":" + (String)text + "}";
        MyUnit myUnit = (MyUnit)objectMapper.readValue((String)text, MyUnit.class);
        final ArrayList output = new ArrayList();
        myUnit.store.subscribe(new DataProcessor(){

            public FactHandle insert(DataHandle handle, Object object) {
                output.add((Person)object);
                return null;
            }

            public void update(DataHandle handle, Object object) {
                throw new UnsupportedOperationException();
            }

            public void delete(DataHandle handle) {
                throw new UnsupportedOperationException();
            }
        });
        Assertions.assertEquals((int)input.size(), (int)output.size());
        Assertions.assertTrue((boolean)input.containsAll(output));
    }

    @Test
    public void testSingletonStore() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new KogitoModule());
        Person input = new Person("Mario", 46);
        Object text = objectMapper.writeValueAsString((Object)input);
        text = "{\"store\":" + (String)text + "}";
        AnotherUnit myUnit = (AnotherUnit)objectMapper.readValue((String)text, AnotherUnit.class);
        final ArrayList output = new ArrayList();
        myUnit.store.subscribe(new DataProcessor(){

            public FactHandle insert(DataHandle handle, Object object) {
                output.add((Person)object);
                return null;
            }

            public void update(DataHandle handle, Object object) {
                throw new UnsupportedOperationException();
            }

            public void delete(DataHandle handle) {
                throw new UnsupportedOperationException();
            }
        });
        Assertions.assertEquals((Object)input, output.get(0));
    }

    public static class AnotherUnit {
        private SingletonStore<Person> store;

        public AnotherUnit() {
        }

        public AnotherUnit(SingletonStore<Person> store) {
            this.store = store;
        }

        public SingletonStore<Person> getStore() {
            return this.store;
        }

        public void setStore(SingletonStore<Person> store) {
            this.store = store;
        }
    }

    public static class MyUnit {
        private DataStore<Person> store;

        public MyUnit() {
        }

        public MyUnit(DataStore<Person> store) {
            this.store = store;
        }

        public DataStore<Person> getStore() {
            return this.store;
        }

        public void setStore(DataStore<Person> store) {
            this.store = store;
        }
    }
}

