/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.sample.generator;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.GeneratedFile;
import org.kie.kogito.codegen.api.Generator;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.api.context.impl.JavaKogitoBuildContext;
import org.kie.kogito.codegen.api.io.CollectedResource;
import org.kie.kogito.codegen.api.utils.CollectedResourcesTestUtils;
import org.kie.kogito.codegen.sample.generator.SampleCodegen;

class SampleCodegenTest {
    SampleCodegenTest() {
    }

    @Test
    void section() {
        SampleCodegen sampleCodegen = SampleCodegen.ofCollectedResources((KogitoBuildContext)JavaKogitoBuildContext.builder().build(), Collections.emptyList());
        Assertions.assertThat((Optional)sampleCodegen.section()).isNotEmpty();
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    public void isEmpty(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        SampleCodegen emptyCodeGenerator = SampleCodegen.ofCollectedResources((KogitoBuildContext)context, Collections.emptyList());
        Assertions.assertThat((boolean)emptyCodeGenerator.isEmpty()).isTrue();
        Assertions.assertThat((boolean)emptyCodeGenerator.isEnabled()).isFalse();
        Collection emptyGeneratedFiles = emptyCodeGenerator.generate();
        Assertions.assertThat((int)emptyGeneratedFiles.size()).isEqualTo(0);
        List<CollectedResource> resources = Arrays.asList(CollectedResourcesTestUtils.toCollectedResource((String)"/sampleFile1.txt"), CollectedResourcesTestUtils.toCollectedResource((String)"/sampleFile2.txt"));
        SampleCodegen codeGenerator = SampleCodegen.ofCollectedResources((KogitoBuildContext)context, resources);
        Assertions.assertThat((boolean)codeGenerator.isEmpty()).isFalse();
        Assertions.assertThat((boolean)codeGenerator.isEnabled()).isTrue();
        Collection generatedFiles = codeGenerator.generate();
        int minNumberOfResources = context.hasRESTForGenerator((Generator)codeGenerator) ? 1 : 0;
        Assertions.assertThat((int)generatedFiles.size()).isGreaterThanOrEqualTo(minNumberOfResources);
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void generate(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        List<CollectedResource> resources = Arrays.asList(CollectedResourcesTestUtils.toCollectedResource((String)"/sampleFile1.txt"), CollectedResourcesTestUtils.toCollectedResource((String)"/sampleFile2.txt"));
        SampleCodegen codeGenerator = SampleCodegen.ofCollectedResources((KogitoBuildContext)context, resources);
        Collection generatedFiles = codeGenerator.generate();
        if (contextBuilder.build().hasRESTForGenerator((Generator)codeGenerator)) {
            Assertions.assertThat((Iterable)generatedFiles).hasSize(1);
            List generatedRests = generatedFiles.stream().filter(gf -> gf.type() == Generator.REST_TYPE).collect(Collectors.toList());
            Assertions.assertThat(generatedRests).hasSize(1);
            CompilationUnit compilationUnit = StaticJavaParser.parse((String)new String(((GeneratedFile)generatedRests.get(0)).contents()));
            Optional optionalFieldDeclaration = compilationUnit.findFirst(FieldDeclaration.class, SampleCodegen::isSampleRuntimeField);
            Assertions.assertThat((Optional)optionalFieldDeclaration).isNotEmpty();
            FieldDeclaration fieldDeclaration = (FieldDeclaration)optionalFieldDeclaration.get();
            if (context.hasDI()) {
                Assertions.assertThat((List)fieldDeclaration.getAnnotations()).isNotEmpty();
            } else {
                Assertions.assertThat((Optional)fieldDeclaration.getVariable(0).getInitializer()).isNotEmpty();
            }
        } else {
            Assertions.assertThat((Iterable)generatedFiles).isEmpty();
        }
    }

    @Test
    void configGenerator() {
        SampleCodegen sampleCodegen = SampleCodegen.ofCollectedResources((KogitoBuildContext)JavaKogitoBuildContext.builder().build(), Collections.emptyList());
        Assertions.assertThat((Optional)sampleCodegen.configGenerator()).isNotEmpty();
    }
}

