/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen.sample.generator;

import com.github.javaparser.ast.body.MethodDeclaration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.kie.kogito.codegen.api.context.KogitoBuildContext;
import org.kie.kogito.codegen.sample.generator.SampleContainerGenerator;
import org.kie.kogito.codegen.sample.generator.SampleResource;

class SampleContainerGeneratorTest {
    SampleContainerGeneratorTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"org.kie.kogito.codegen.api.utils.KogitoContextTestUtils#contextBuilders"})
    void compilationUnit(KogitoBuildContext.Builder contextBuilder) {
        KogitoBuildContext context = contextBuilder.build();
        List<SampleResource> resources = Arrays.asList(new SampleResource("sampleFile1", "content1"), new SampleResource("sampleFile2", "content2"));
        SampleContainerGenerator sampleContainerGenerator = new SampleContainerGenerator(context, resources);
        Optional<String> optionalLoadContent = sampleContainerGenerator.compilationUnit().findFirst(MethodDeclaration.class, md -> "loadContent".equals(md.getName().asString())).flatMap(MethodDeclaration::getBody).map(Objects::toString);
        Assertions.assertThat(optionalLoadContent).isNotEmpty();
        String loadContent = optionalLoadContent.get();
        resources.forEach(resource -> ((AbstractStringAssert)Assertions.assertThat((String)loadContent).contains(new CharSequence[]{resource.getName()})).contains(new CharSequence[]{resource.getContent()}));
    }
}

