/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.codegen;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.JavaCompiler;
import org.drools.compiler.commons.jci.compilers.JavaCompilerFactory;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.rule.builder.dialect.java.JavaDialectConfiguration;
import org.kie.kogito.Application;
import org.kie.kogito.codegen.ApplicationGenerator;
import org.kie.kogito.codegen.GeneratedFile;
import org.kie.kogito.codegen.Generator;
import org.kie.kogito.codegen.process.ProcessCodegen;
import org.kie.kogito.codegen.rules.RuleCodegen;

public class AbstractCodegenTest {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.getInstance().loadCompiler(JavaDialectConfiguration.CompilerType.NATIVE, "1.8");

    protected Application generateCodeProcessesOnly(String ... processes) throws Exception {
        return this.generateCode(Arrays.asList(processes), Collections.emptyList());
    }

    protected Application generateCodeRulesOnly(String ... rules) throws Exception {
        return this.generateCode(Collections.emptyList(), Arrays.asList(rules), true);
    }

    protected Application generateCode(List<String> processResources, List<String> rulesResources) throws Exception {
        return this.generateCode(processResources, rulesResources, false);
    }

    protected Application generateCode(List<String> processResources, List<String> rulesResources, boolean hasRuleUnit) throws Exception {
        ApplicationGenerator appGen = new ApplicationGenerator(this.getClass().getPackage().getName(), new File("target/codegen-tests")).withRuleUnits(hasRuleUnit).withDependencyInjection(false);
        if (!rulesResources.isEmpty()) {
            appGen.withGenerator((Generator)RuleCodegen.ofFiles((Path)Paths.get("src", "test", "resources"), (Collection)rulesResources.stream().map(resource -> new File("src/test/resources", (String)resource)).collect(Collectors.toList())));
        }
        if (!processResources.isEmpty()) {
            appGen.withGenerator((Generator)ProcessCodegen.ofFiles((Collection)processResources.stream().map(resource -> new File("src/test/resources", (String)resource)).collect(Collectors.toList())));
        }
        Collection generatedFiles = appGen.generate();
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[generatedFiles.size()];
        int index = 0;
        for (GeneratedFile entry : generatedFiles) {
            String fileName = entry.relativePath();
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.contents());
        }
        CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClass().getClassLoader());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object[])result.getErrors()).hasSize(0);
        TestClassLoader cl = new TestClassLoader(this.getClass().getClassLoader(), trgMfs.getMap());
        Class<?> app = Class.forName(this.getClass().getPackage().getName() + ".Application", true, cl);
        return (Application)app.newInstance();
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public TestClassLoader(ClassLoader parent, Map<String, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            for (Map.Entry<String, byte[]> entry : extraClassDefs.entrySet()) {
                this.extraClassDefs.put(entry.getKey().replaceAll("/", ".").replaceFirst("\\.class", ""), entry.getValue());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }
}

